<?php


namespace Core\MailingPreparation;

class MailingAnchorPrepare implements MailingPreparationInterface
{

    protected $labels = [];

    /**
     * @param string $body
     * @param string $key
     * @return string
     */
    public function prepareBody(string $body, string $key): string
    {

        if (preg_match_all('~<a.*?href=[\'|"](.*?)[[\'|"].*?<\/a~is', $body, $m)) {

            $rUrls = [];
            $urls = array_unique($m[1]);

            foreach ($urls as $k => $url) {

                $param = !empty($key) ? (strpos($url, '?') !== false ? '&' : '?') . 'key=' . $key : '';

                if (strpos($url, 'http') === false) {
                    $newUrl = trim(getenv('BASE_URL'), '/') . $url . $param;
                } else {
                    $newUrl = $url . $param;
                }

                $rUrls[$m[0][$k]] = str_replace($url, $newUrl, $m[0][$k]);
            }

            $body = str_replace(
                array_keys($rUrls),
                $rUrls,
                $body
            );

        }

        return $body;
    }

    public function getData(): array
    {
        return [];
    }


    public function getLabels(): array
    {
        return $this->labels;
    }

}