<?php

namespace Core\Form\Control;

use Core\Template\Template;

/**
 * Description of DatePicker
 *
 * @author Dmitriy
 */
class DatePicker extends Input
{

    protected $template;
    protected $twig;
    protected $format = 'dd/mm/yy';

    function __construct($name, Template $template, \Twig_Environment $twig, $value = null, $width = false)
    {
        parent::__construct($name, $value, $width);
        $this->template = $template;
        $this->twig = $twig;
    }

    public function render(): string
    {
        $this->setClass('width100');
        $selector = $this->getName();
        $this->setId($selector);

        (new \Widgets\Jquery\DatePicker\DatePicker("#" . $selector, $this->template, $this->twig))
            ->setFormat($this->format)
            ->render();

        return parent::render();
    }

    /**
     * @param mixed $format
     * @return DatePicker
     */
    public function setFormat(string $format)
    {
        $this->format = $format;
        return $this;
    }
}
