<?php


namespace Core\MailingPreparation;

use Core\TwigAwareInterface;
use Core\TwigAwareTrait;

/**
 * подготавливает письма заменяя метки значениями
 * Class MailingCook
 * @package Core\MailingPreparation
 */
class MailingCook implements TwigAwareInterface
{
    use TwigAwareTrait;

    protected $drivers = [];

    /**
     * @param MailingPreparationInterface $driver
     * @return $this
     */
    public function addDriver(MailingPreparationInterface $driver, string $name = null)
    {
        if(!$name){
            $name = md5(microtime());
        }

        $this->drivers[$name] = $driver;
        return $this;
    }

    /**
     * @param string $body
     * @param string $key
     * @return string
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\SyntaxError
     */
    public function prepare(string $body, string $email, string $key): string
    {

        /**
         * @var MailingPreparationInterface $driver
         */
        foreach ($this->drivers as $driver) {
            $body = $driver->prepareBody( $body,  $key);
        }

        $data = [];
        foreach ($this->drivers as $driver) {
            $data += $driver->getData();
        }

        $this->twig->setCache(false);
        $this->twig->disableStrictVariables();
        $this->twig->disableAutoReload();

        $result
             = $this->twig->createTemplate($body,md5(microtime()))->render($data);

        return $result;
    }

    /**
     * @return array
     */
    public function getSnippets(): array
    {
        $ar = [];
        /**
         * @var MailingPreparationInterface $driver
         */
        foreach ($this->drivers as $driver) {
            $ar += $driver->getLabels();
        }

        return $ar;
    }
}