<?php

namespace Core\Table\BootstrupTable;

use ActiveTableEngine\Contracts\TableRenderingInterface;
use ActiveTableEngine\Contracts\TableSortingInterface;

class Table implements TableRenderingInterface, TableSortingInterface
{

    protected $class = 'stdtable';

    /**
     * @param string $class
     * @return Table
     */
    public function setClass(string $class): Table
    {
        $this->class = $class;
        return $this;
    }


    /**
     * @param array $rows
     * @return string
     * @throws \Exception
     */
    public function renderBody(array $rows): string
    {

        $table = \Donquixote\Cellbrush\Table\Table::create();
        $table->addClass($this->class);
        $col_names = $build_head = [];
        $table->thead()->addRowName('head row');
        $build_str = '';

        $i = 0;
        foreach ($this->columns as $key => $column) {

            $col_names [] = $key;

            $table->thead()->th('head row', $key, $column);
            $build_str .= sprintf('\'%s\' => $this->prepareRow($row,$this->columns[%s]),', $key, $i);
            $build_head[$i] = 'head' . ($i % 2 == 0 ? 1 : 0);
            $i++;
        }


        $table->addColNames($col_names);
        $table->addColClasses($build_head);

        //dump($build_str);exit;

        $i = 0;
        $table->addRowStriping();
        if (count($rows) > 0) {
            foreach ($rows as $row) {

                $data = [];

                foreach ($this->columns as $key => $caption){
                    $data[$key] = $this->prepareRow($row, $key);
                }
               // $script = sprintf('$table->addRow($i)->tdMultiple([%s]);', rtrim($build_str, ','));

                //eval($script);

                $table->addRow($i)->tdMultiple($data);

                $i++;
            }
        } else {
            $table
                ->addRowName('head row')
                ->td('head row', '', 'В таблице нет данных');
        }

        //для подвала
        //$this->addFotterRows($table);

        return $table->render();
    }

    public function renderHeader(array $rows): string
    {

        $this->columns = $rows;
        return "";
    }

    public function renderTop(array $rows): string
    {
        // TODO: Implement renderTop() method.

        return "";
    }

    public function renderBottom(): string
    {
        // TODO: Implement renderBottom() method.
        return "";
    }

    public function setSortedFields(array $fields)
    {
        // TODO: Implement setSortedFields() method.
    }

    /**
     *
     * @param type $Model
     * @param type $Column
     * @return type
     */
    protected function prepareRow(array $row, $column)
    {

        return $row[$column];

        $resultReal = method_exists($Model, 'get' . $Column->getName()) ? $Model->{"get" . $Column->getName()}() : '&nbsp;';

        if (is_callable($Column->getFn()) || (is_array($Column->getFn()) and is_object($Column->getFn()[0]))) {
            $result = call_user_func($Column->getFn(), $Model);
        } else {
            $result = $resultReal;
        }


        if (isset($this->summary[$Column->getName()]) && $resultReal > 0) {
            $this->summary[$Column->getName()] += (float)$resultReal;
        }

        return $result;
    }
}