<?

namespace Core\Form\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Description of CaptchaValidator
 *
 * @author Admin
 */
class ReCaptchaValidator extends CaptchaValidator
{

    public function validate($value, Constraint $constraint)
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,
                    http_build_query([
            "secret"   => $constraint->getReCaptcha()->getSecretKey(),
            "response" => isset($_POST["g-recaptcha-response"]) ? $_POST["g-recaptcha-response"] : null,
            "remoteip" => $_SERVER["REMOTE_ADDR"]
        ]));

        
// Receive server response ...
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $server_output = curl_exec($ch);
        $res = json_decode($server_output,true);


        
        if(!$result = isset($res) && $res["success"]==true){
  
            switch (TRUE) {
                case is_array($res["error-codes"]) && in_array("timeout-or-duplicate",$res["error-codes"]):

                    $message = "Время жизни проверочного кода истекло";

                    break;

                default:
                    $message = $constraint->message;
                    break;
            }            
            
            
              $this->context->buildViolation($message)
                ->setParameter('{{ string }}', "код")
                ->addViolation();
        }
        
        curl_close($ch);
        
        return $res;
    }

}