<?php

namespace Core\Console;

use Symfony\Component\Console\Application as CoreApp;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Finder\Finder;

class Application extends CoreApp
{

    /**
     * Gets the default commands that should always be available.
     *
     * @return array An array of default Command instances
     */
    protected function getDefaultCommands()
    {
        // Keep the core default commands to have the HelpCommand
        // which is used when using the --help option
        $defaultCommands = parent::getDefaultCommands();
        $defaultCommands [] = new Commands\PrepareDirsCommand();
        $defaultCommands [] = new Commands\InfoCommand();
        $defaultCommands [] = new Commands\InstallPackagesCommand;
        $defaultCommands [] = new Commands\InstallCommand;
        $defaultCommands [] = new Commands\SeedBuildCommand;
        $defaultCommands [] = new Commands\SeedResetCommand;
        $defaultCommands [] = new Commands\MigrationMigrateCommand();
        $defaultCommands [] = new Commands\MigrationDiffCommand();
        $defaultCommands [] = new Commands\SqlBuildCommand();
        $defaultCommands [] = new Commands\SqlInsertCommand();

        $defaultCommands [] = new Commands\BuildModuleCommand();
        $defaultCommands [] = new Commands\BuildModelCommand();
        $defaultCommands [] = new Commands\BuildEntityCommand();

        $defaultCommands [] = new Commands\StatusCommand();
        $defaultCommands [] = new Commands\SessionCommand();
        $defaultCommands [] = new Commands\Cache();

        return $defaultCommands;
    }
}
