<?php

use Dotenv\Dotenv;
use League\Container\Container;
use League\Container\ReflectionContainer;

if (!BASEPATH) {
    die('BASEPATH not set');
}

require_once BASEPATH . '/vendor/autoload.php';

/**
 * constants
 * @deprecated
 */
define('PACKPATH', BASEPATH . DIRECTORY_SEPARATOR . 'packages');


/**
 * Dotenv setup
 */
try {
    $dotenv = Dotenv::createUnsafeImmutable(BASEPATH);
    $dotenv->load();
} catch (\Dotenv\Exception\InvalidPathException $ex) {
    die('environment variables are not defined, please create .env file');
} catch (\Exception $ex) {
    die($ex->getMessage());
}

foreach (['DB_NAME', 'DB_PASS', 'DB_USER', 'BASE_URL'] as $const) {
    if (!getenv($const)) {
        die($const . ' not set!');
    }
}

require_once __DIR__ . '/config_database.php';

/**
 * Container setup
 */
$container = new Container();

$container->delegate(
    new ReflectionContainer() // Auto-wiring
);


/**
 * service providers
 */
if (!file_exists(BASEPATH . '/app/bootstrap.php')) {
    die('please, set bootstrap.php to bootstrap /app');
}

$config = include_once BASEPATH . '/app/bootstrap.php';

if(!isset($config['providers'])){
    die('please, set providers in app/bootstrap.php');
}
$items = $config['providers'];


//routes
$routes = $viewPaths  = $commandBusMap = [];


/**
 * @var \Core\Contracts\ServiceProviderInterface $item
 */
foreach ($items as $item) {
    $container->addServiceProvider($item);
    $routes = array_merge($routes, $item::getRoutes());
    $commandBusMap = array_merge($commandBusMap,$item::getCommandBusMap());
    $viewPaths [ $item::getPackageName() ] = $item::getViewsPath();
}

//command Bus prepare
$container->share(\spaceonfire\CommandBus\CommandBus::class,
    new \spaceonfire\CommandBus\CommandBus(
        new \spaceonfire\CommandBus\Mapping\MapByStaticList($commandBusMap),
        [],
        $container
    ));


//проход еще раз по провайдерам и заверешение инициализации
foreach ($items as $item) {
    $container->get($item)->afterInit($container);
}


$routes []= [['GET', 'POST'], '/[{more:.*}]', [\Diamond\Controllers\IndexController::class, 'index']];


//Twig views
foreach ($viewPaths as $package => $path) {
    if (!is_dir($path)) {
        throw new RuntimeException(sprintf('path %s view for package not found', $path));
    }
    $container->get(\Twig\Environment::class)->getLoader()->prependPath(realpath($path), $package);
}

//Session
$lifetime = $container->get(\Diamond\Config\Main::class)->getSessionLife();
if (!$lifetime) {
    $lifetime = 1;
}
session_name('SSID');
session_set_save_handler($container->get(\Core\Concrete\PropelSessionHandler::class), false);
session_set_cookie_params($lifetime * 60 * 60);//перевод секунды
ini_set('session.gc_maxlifetime', $lifetime * 60 * 60);//перевод в секунды




/**
 * add singliton
 */
\Core\Application\Loader::getInstance()->import('DI', $container);


