<?php

namespace Core;

/**
 * Description of ModuleController
 *
 * @author d.lanec
 */
abstract class ModuleController extends BaseController implements ModuleInterface
{

    protected const DEFTPL = "default";

    /**
     * @var string|null
     */
    public $tpl;

    /**
     * @var array
     */
    protected $data = [];



    /**
     * @param string $name
     * @param $value
     * @return ModuleController
     */
    protected function addData(string $name, $value): self
    {
        $this->data[$name] = $value;
        return $this;
    }

    /**
     * @param array $data
     * @return ModuleController
     */
    public function setData(array $data): self
    {
        $this->data = $data;
        return $this;
    }


    /**
     * @param string $view
     * @param array $data
     * @return string
     * @throws \ReflectionException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    protected function render($view = self::DEFTPL, $data = array()): string
    {
        if (is_array($view)) {
            $data = (array)$view;
            $view = self::DEFTPL;
        }
        if ($this->tpl > '') {
            $view = $this->tpl;
        }

        $tpl = $this->getModuleTemplatePath();

        $this->twig->getLoader()->prependPath($tpl);
        return $this->twig->render($view . '.twig', $data);
    }

    /**
     * Получить путь к шаблону
     *
     * @return string
     * @throws \ReflectionException
     */
    protected function getModuleTemplatePath(): string
    {

        $ref = new \ReflectionClass($this);

        $tpl = (new \SplFileInfo($ref->getFileName()))->getPath() . DIRECTORY_SEPARATOR . 'tpl';

        return $tpl;
    }

    /**
     * @param array $params
     */
    public function setParams(array $params = array()): void
    {

        $ref = new \ReflectionClass($this);
        $name = preg_replace('~.*\\\(.*?)$~', '$1', get_class($this));

        if (class_exists($ref->getName() . 'Params')) {

            $className = $ref->getName() . 'Params';

            $paramOb = new $className;

            if (!method_exists($paramOb, 'buildParams')) {
                throw new \RuntimeException(sprintf("method 'buildParams' not found in params Dto '%s'", $className));
            }

            $paramOb->buildParams($params);

            $this->params = $paramOb;

        } else {

            foreach ($params as $param => $value) {
                if (!property_exists($this, $param)) {

                    throw new \RuntimeException(sprintf("property '%s' not found in module '%s'", $param, $name));
                }
                $this->{$param} = $value;
            }

        }

    }

    /**
     * @param string $name
     * @return string
     * @throws Exceptions\BaseException
     * @throws \ReflectionException
     */
    protected function includeTpl(string $name): string
    {

        ob_start();
        $tpl = sprintf('%s/%s.twig', $this->getModuleTemplatePath(), $name);

        if (!file_exists($tpl)) {
            throw new Exceptions\BaseException(sprintf('template %s.twig not found', $name));
        }
        include $tpl;

        return ob_get_clean();
    }

    /**
     * Фукнкция пост обработки модуля
     */
    public function afterProcess(): void
    {

    }
}
