<?php


namespace Core\Concrete;

use Aura\Auth\Adapter\AdapterInterface;
use Aura\Auth\Service\ResumeService;
use Aura\Auth\Session\Timer;

class AuthFactory extends \Aura\Auth\AuthFactory
{

    /**
     * @param AdapterInterface|null $adapter
     * @return \Aura\Auth\Service\LoginService|LoginService
     */
    public function newLoginService(AdapterInterface $adapter = null)
    {
        return new LoginService(
            $this->fixAdapter($adapter),
            $this->session
        );
    }

    /**
     * @param AdapterInterface|null $adapter
     * @return \Aura\Auth\Service\LogoutService|LogoutService
     */
    public function newLogoutService(AdapterInterface $adapter = null)
    {
        return new LogoutService(
            $this->fixAdapter($adapter),
            $this->session
        );
    }

    /**
     * @param AdapterInterface|null $adapter
     * @param int $idle_ttl
     * @param int $expire_ttl
     * @return ResumeService
     */
    public function newResumeService(
        AdapterInterface $adapter = null,
        $idle_ttl = 1440,
        $expire_ttl = 14400
    )
    {

        $adapter = $this->fixAdapter($adapter);

        $timer = new Timer(
            ini_get('session.gc_maxlifetime'),
            ini_get('session.cookie_lifetime'),
            $idle_ttl,
            $expire_ttl
        );

        $logout_service = new LogoutService(
            $adapter,
            $this->session
        );

        return new ResumeService(
            $adapter,
            $this->session,
            $timer,
            $logout_service
        );
    }
}