<?php


namespace Core\MailingPreparation;


use Diamond\Config\Main;

class MailingDefaultData implements MailingPreparationInterface
{

    protected $labels = [
        'signature' => '{{signature|raw}} - подпись'
    ];

    protected $mainConf;

    public function __construct(Main $mainConf)
    {
        $this->mainConf = $mainConf;
    }

    public function prepareBody(string $body, string $key): string
    {
        return $body;
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        $data['signature'] = $this->mainConf->getSignature();
        $data['site_name'] = $this->mainConf->getSite_name();
        return $data;
    }

    public function getLabels(): array
    {
        return $this->labels;
    }

}