<?php

namespace Core;

/**
 * Description of ModuleController
 *
 * @author d.lanec
 */
abstract class ModuleController extends BaseController implements ModuleInterface
{

    const DEFTPL = "default";

    public $tpl = false;

    protected $data = [];

    /**
     * Пополнение массива с данными
     * @param type $name
     * @param type $value
     * @return $this
     */
    protected function addData($name, $value)
    {
        $this->data[$name] = $value;
        return $this;
    }

    /**
     * Установка масссива с данными
     * @param array $data
     * @return $this
     */
    public function setData(array $data)
    {
        $this->data = $data;
        return $this;
    }


    /**
     * @param string $view
     * @param array $data
     * @return string
     * @throws \ReflectionException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    protected function render($view = self::DEFTPL, $data = array()): string
    {

        if (is_array($view)) {
            $data = $view;
            $view = self::DEFTPL;
        }

        if ($this->tpl !== false)
            $view = $this->tpl;

        $tpl = $this->getModuleTemplatePath();

        $this->twig->getLoader()->prependPath($tpl);
        return $this->twig->render($view . '.twig', $data);
    }

    /**
     * Получить путь к шаблону
     *
     * @return string
     * @throws \ReflectionException
     */
    protected function getModuleTemplatePath(): string
    {

        $ref = new \ReflectionClass($this);

        $tpl = (new \SplFileInfo($ref->getFileName()))->getPath() . DIRECTORY_SEPARATOR . 'tpl';

        return $tpl;
    }

    /**
     * set module params
     * @param array $params
     * @return $this
     * @throws \Exception
     */
    public function setParams(array $params = array())
    {

        foreach ($params as $param => $value) {
            if (!property_exists($this, $param)) {
                $name = preg_replace('~.*\\\(.*?)$~', "$1", get_class($this));
                throw new \Exception(sprintf("property '%s' not found in module '%s'", $param, $name));
            }
            $this->{$param} = $value;
        }
        return $this;
    }

    /**
     * @param $name
     * @return string
     * @throws Exceptions\BaseException
     */
    protected function includeTpl($name): string
    {

        ob_start();
        $tpl = sprintf("%s/%s.twig", $this->getModuleTemplatePath(), $name);

        if (!file_exists($tpl)) {
            throw new Exceptions\BaseException(sprintf("template %s.twig not found", $name));
        }

        include $tpl;

        $content = ob_get_clean();

        return $content;
    }

    /**
     * Фукнкция пост обработки модуля
     */
    public function afterProcess(): void
    {

    }
}
