<?php
namespace Core\Logger;

use Monolog\Formatter\LineFormatter;
use Monolog\Formatter\NormalizerFormatter;

class FileFormatter extends LineFormatter
{

    const SIMPLE_FORMAT = "[%datetime%] %level_name%: %message% \n%context% \n%extra%\n";

    /**
     * @param $str
     * @return mixed
     */
    protected function replaceNewlines($str)
    {
        return $str;
    }

    /**
     * @param $data
     * @return mixed|string
     */
    protected function convertToString($data)
    {
        if (null === $data || is_bool($data)) {
            return var_export($data, true);
        }

        if (is_scalar($data)) {
            return (string) $data;
        }

        if(!count($data)){
            return "";
        }

        return print_r($data,true);
    }
}