<?php

namespace Core\Form;

use Core\Form\Control\Button;
use Core\Form\Control\FormControl;
use Core\Form\Control\Hidden;
use Core\Form\Control\Label;
use Core\Form\Control\Row;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints;
use Symfony\Component\Validator\Validation;
use Twig_Environment;

/**
 * Простая форма
 *
 *
 * @package System
 * @subpackage library
 * @author Дмитрий
 */
class Simpleform
{

    //имя формы
    protected $name;
    //объект контролов
    protected $controls = [
    ];
    //адрес формы
    protected $action;
    //поля
    protected $fields = array();
    //поля управления
    protected $fields_control = array();
    //служебные скрытые поля
    protected $hidden_fields = array();
    //на сабмит формы
    protected $onsubmit;
    protected $captions = [
    ];
    protected $validation_rules = [
    ];
    protected $fieldsdesc = [
    ];
    protected $custom_messages = [
    ];
    //действие
    //create - создание записи
    //read - чтение записи 
    //update - обновление записи 
    //delete - удаление записи
    //view - отсутсвие какого либо действия или просто просмотр формы
    private $fn;
    //строки для хранения произвольной информации
    //protected $other_rows = array();
    //Основной массив с контроллами формы
    // protected $form_fields = array();

    protected $class;
    protected $attributes = [
    ];

    /**
     * Привила валидации
     * - заполняются для автозаполнения полей
     * - заполняются вторичными моделями
     * @var type
     */
    //protected $validate = array();
    //оезультат валидации полей
    //protected $validation_result;
    //форматируем оформление ошибки
    //public $error_delimiter = array('<div class="notibar msgalert"><span class="icon"></span><a class="close"></a><p>', '</p></div>');
    //форматируес оформление успешного действия 
    protected $message_blank = '<div class="notibar %s"><span class="icon"></span><a class="close"></a><p>%s</p></div>';
    //Использовать метку * при выводе обязательных полей
    protected $required_label = '<span class="required_sign">*</span>';
    protected $formRow = '<p class="%s">{{%s.label}}<span class="field">{{%s.control}}</span></p>';
    protected $formHeader = '<p class="stdformrow"><span class="hd">{{%s.control}}</span></p>';
    protected $formLabel = '<label for="%s">%s</label>';
    protected $formControl = '<p class="stdformrow">{{%s.control}}</p>';
    protected $formButton = "<p class=\"stdformbutton\">%s</p>";
    //контролы для игнора
    //не участвют в сохранении данных, спец в оформлении
    //public $ignore_controls = array('submit', 'cancel', 'button', 'hidden', 'textmessage');
    //класс
    //public $class = 'stdform stdform2';
    //использовать двоиточие в label
    //public $colon = false;
    //события формы
    //protected $before_create = array();
    //protected $after_create = array();
    //protected $before_update = array();
    //protected $after_update = array();
    //protected $before_get = array();
    //protected $after_get = array();
    //protected $before_delete = array();
    //protected $after_delete = array();
//    public $msg = array(
//        'insert_success' => 'Запись успешно добавлена.',
//        'update_success' => 'Запись успешно обновлена.',
//        'delete_success' => 'Запись успешно удалена.',
//        'back_link' => 'Вернуться назад',
//        'validation_rules' => array(
//            'valid_captcha' => 'Введенный Вами текст не совпадает с изображением. Код защиты необходимо ввести заново',
//        )
//    );
    protected $custom_tpl;
    //protected $hide_validation = FALSE;    

    /**
     * сбмит формы
     * @var type
     */
    static $ACTION_SUBMIT = 'submit';

    /**
     * отображение формы
     * @var type
     */
    static $ACTION_VIEW = 'view';

    /**
     *
     * @var Twig_Environment
     */
    protected $twig;
    static $VALIDATION_SUCCESS = 'validation_success';
    static $VALIDATION_PREPARE = 'validation_prepare';
    protected $events = [];
    protected $validation_results = [];
    protected $request;
    protected $validation;

    const MESSAGE_SUCCESS = "msgsuccess";
    const MESSAGE_INFO = "msginfo";
    const MESSAGE_ERROR = "msgalert";
    const MESSAGE_BACK_URL = "Вернуться назад";
    const MESSAGE_ADD_URL = "Добавить новую запись";

    protected $backUrl;
    protected $newRecordUrl;
    protected $customValidations = [];
    protected $buffer = [];

    use \Core\TwigAwareTrait;

    function __construct($name, $action = '', Request $request = null)
    {
        $this
            ->setName($name)
            ->setAction($action);

        $this->request = !empty($request) ? $request : Request::createFromGlobals();

        $this->events[self::$VALIDATION_PREPARE] = [];
        $this->events[self::$VALIDATION_SUCCESS] = [];

        $this->validation = Validation::createValidator();
    }

    /**
     *
     * @return array
     */
    function getBuffer(): array
    {
        return $this->buffer;
    }

    /**
     *
     * @param type $buffer
     * @return string
     */
    function addBuffer(string $buffer)
    {
        $this->buffer [] = $buffer;
        return $this;
    }

    public function addCustomValidation($name, $callable)
    {
        $this->customValidations[$name] = $callable;
        return $this;
    }

    function setFormRow($formRow)
    {
        $this->formRow = $formRow;
        return $this;
    }

    function setFormButton($formButton)
    {
        $this->formButton = $formButton;
        return $this;
    }

    function setFormHeader($formHeader)
    {
        $this->formHeader = $formHeader;
        return $this;
    }

    function setFormLabel($formLabel)
    {
        $this->formLabel = $formLabel;
        return $this;
    }

    function setFormControl($formControl)
    {
        $this->formControl = $formControl;
        return $this;
    }

    /**
     *
     * @param type $custom_tpl
     * @return $this
     */
    function setCustom_tpl($custom_tpl)
    {
        $this->custom_tpl = $custom_tpl;
        return $this;
    }

    public function addValidationSuccessEvent($event)
    {
        $this->events[self::$VALIDATION_SUCCESS][] = $event;
        return $this;
    }

    public function addValidationPrepareEvent($event)
    {
        $this->events[self::$VALIDATION_PREPARE][] = $event;
        return $this;
    }

    function getRequired_label()
    {
        return $this->required_label;
    }

    function setRequired_label($required_label)
    {
        $this->required_label = $required_label;
        return $this;
    }

    function getName()
    {
        return $this->name;
    }

    function getAction()
    {
        return $this->action;
    }

    function getClass()
    {
        return $this->class;
    }

    function getAttributes()
    {
        return $this->attributes;
    }

    function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    function setAction($action)
    {
        $this->action = $action;
        return $this;
    }

    function setClass($class)
    {
        $this->class = $class;
        return $this;
    }

    function addClass($class)
    {
        $this->class .= ' ' . $class;
        return $this;
    }

    function setAttributes($attributes)
    {
        $this->attributes = $attributes;
        return $this;
    }

    public function addHeader($txt)
    {
        return $this->addControl((new Control\Header($txt))->setName(str_replace(" ", "_", $txt)));
    }

    public function addFieldControl(Control\BaseControl $control, $caption = null, $validationrule = null, $desc = null)
    {
        if (is_a($control, Control\FormField::class)) {
            return $this->addField($control, $caption, $validationrule, $desc);
        }

        return $this->addControl($control);
    }

    public function addControl(FormControl $control)
    {
        $this->fields [] = $control;
        return $this;
    }

    /**
     *
     * @param \Core\Form\Control\FormField $control
     * @param type $caption
     * @param type $validationrule
     * @param type $desc
     * @return $this
     */
    public function addField(Control\FormField $control, $caption = null, $validationrule = null, $desc = null)
    {
        $this->fields [] = $control;
        $this->captions[$control->getName()] = $caption;

        if (!empty($validationrule)) {
            $this->validation_rules[$control->getName()] = $validationrule;
        }

        if (!empty($desc)) {
            $this->fieldsdesc[$control->getName()] = $desc;
        }

        return $this;
    }

    public function render()
    {

        switch ($this->definitionAction()) {
            case self::$ACTION_SUBMIT:

                $data = $this->getPostData();

                $events = (array)$this->events[self::$VALIDATION_PREPARE];

                $firstForm = $this->generateForm();

                foreach ($events as $event) {
                    if (!$data = call_user_func($event, $data, $this)) {

                        $modForm = $this->generateForm();

                        if ($firstForm == $modForm) {
                            $this->addBuffer($this->createMessage("Ошибка в подготовке данных"));
                        }

                        $this->addBuffer($modForm);

                        return implode("\r\n", $this->getBuffer());
                    }
                }
                //dump($this);
                //dump($data);
                //dump($this->validation_rules);
                //Процесс валидации
                $this->validationProcess($data);

                if (count($this->validation_results) == 0) {

                    $events = (array)$this->events[self::$VALIDATION_SUCCESS];

                    foreach ($events as $event) {

                        $result = call_user_func($event, $data, $this);

                        if (!$result) {
                            break;
                        }
                    }
                    return $this->getCustomMessages() . implode("\r\n", $this->getBuffer());
                }


                break;
        }

        return $this->generateForm();
    }

    /**
     *
     */
    protected function validationProcess(array $data)
    {
        $validation = $this->validation;

        foreach ($this->fields as $Field) {

            if (!isset($this->validation_rules[$Field->getName()]))
                continue;

            $rules = $this->buildValidationRules($Field);

            if (!isset($data[$Field->getName()])) {
                continue;
            }

            $violations = $validation->validate($data[$Field->getName()], $rules);

            if (0 !== count($violations)) {
                // there are errors, now you can show them
                foreach ($violations as $violation) {

                    $this->validation_results[$Field->getName()] = $violation->getMessage();
                }
            }
        }
    }

    /**
     *
     * @param \Core\Form\Control\BaseControl $Field
     * @return \Core\Form\Constraints\Custom
     */
    protected function buildValidationRules(Control\BaseControl $Field)
    {
        $rules = $this->validation_rules[$Field->getName()];

        if (!is_array($rules)) {

            $rules = explode("|", $rules);
        }
        $correct_rules = [];

        foreach ($rules as $rule) {


            switch ($rule) {
                case 'required':

                    $rule = new Constraints\NotBlank();
                    $rule->message = "поле не должно быть пустым.";
                    $correct_rules [] = $rule;

                    break;

                case 'email':
                case 'mail':
                    $rule = new Constraints\Email();
                    $rule->message = "это значение не является действительным адресом электронной почты";
                    $correct_rules [] = $rule;

                    break;

                case 'captcha':

                    $rule = new \Core\Form\Constraints\Captcha($Field);
                    //$rule->message    = "поле не должно быть пустым.";
                    $correct_rules [] = $rule;

                    break;

                case 'recaptcha':

                    $rule = new \Core\Form\Constraints\ReCaptcha($Field);
                    $correct_rules [] = $rule;

                    break;


                default:
                    if (isset($this->customValidations[$rule])) {
                        $rule = new \Core\Form\Constraints\Custom($this->customValidations[$rule]);
                        $correct_rules [] = $rule;
                    }

                    break;
            }
        }


        return $correct_rules;
        //dump($rules); exit('123');
//	array(
//				    new Constraints\Length(array('min' => 10)),
//				    new Constraints\NotBlank(),
//				)
    }

    protected function definitionAction()
    {

        if (!empty($this->request->request->get('submit_' . $this->getName()))) {
            return self::$ACTION_SUBMIT;
        }

        return self::$ACTION_VIEW;
    }

    /**
     * Подготовка данных  из $_POST
     *
     * @return type
     */
    protected function getPostData()
    {
        $data = [];

        foreach ($this->fields as $Field) {
            $value = $this->request->request->get($Field->getName());

            if ($value == -1) {
                $data[$Field->getName()] = null;
            } elseif ($value !== null) {
                $data[$Field->getName()] = $value;
            }

        }

        return $data;
    }

    public function generateForm()
    {
        $data = [];

        $template_twig = $this->twig->createTemplate($this->createTemplate());



        foreach ($this->fields as $Field) {

            if(!$value = $this->request->request->get($Field->getName())){
                $value = $this->request->query->get($Field->getName());
            }

            if ($value!==null) {
                $Field->setValue($value);
            }

            $caption = isset($this->captions[$Field->getName()]) ? $this->captions[$Field->getName()] : null;

            if ($this->isRequeredField($Field->getName())) {
                $caption .= $this->required_label;
            }

            if (isset($this->fieldsdesc[$Field->getName()])) {
                $caption .= sprintf("<small>%s</small>", $this->fieldsdesc[$Field->getName()]);
            }

            $data[$Field->getName()] = [
                'control' => $Field->render(),
                'label'   => sprintf($this->formLabel, $Field->getName(), $caption)
            ];
        }

        return $template_twig->render($data);
    }

    protected $formHtmlTop;
    protected $formHtmlBootom;

    /**
     * @return mixed
     */
    public function getFormHtmlTop()
    {
        return $this->formHtmlTop;
    }

    /**
     * @param mixed $formHtmlTop
     * @return Simpleform
     */
    public function setFormHtmlTop($formHtmlTop)
    {
        $this->formHtmlTop = $formHtmlTop;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getFormHtmlBootom()
    {
        return $this->formHtmlBootom;
    }

    /**
     * @param mixed $formHtmlBootom
     * @return Simpleform
     */
    public function setFormHtmlBootom($formHtmlBootom)
    {
        $this->formHtmlBootom = $formHtmlBootom;
        return $this;
    }


    protected function createTemplate()
    {
        //выйдем
        if (isset($this->custom_tpl))
            return $this->createForm($this->custom_tpl);

        $html = $controls = '';

        if(!empty($this->formHtmlTop)){
            $html .= $this->formHtmlTop;
        }

        //$fields = array_merge(array_merge($this->fields, $this->fields_control),$this->other_rows);
        //__var_dump($this->form_fields);

        foreach ($this->fields as $Field) {

            if (is_a($Field, Row::class)) {
                $html .= sprintf(
                    $this->formControl, $Field->getName()
                );
            } elseif (is_a($Field, Control\Header::class)) {
                $html .= sprintf(
                    $this->formHeader, $Field->getName()
                );
            } elseif (is_a($Field, Button::class) || is_a($Field, Hidden::class)) {

                $controls .= sprintf('{{%s.control}}', $Field->getName());
            } else {


//                $control['rules'] = isset($control['rules']) ? $control['rules'] : '';
//                $control['label'] = isset($control['label']) ? $control['label'] : '';
//
//				
//				if(is_array($control['rules'])){
//					$rules = '';
//					foreach($control['rules'] as $rule)
//						if(is_string($rule)) $rules  .= $rule.'|';
//						
//					$control['rules'] = $rules;
//				}
                //$class = str_replace('|', ' ', $control['rules']);
                //$rules = $control['rules'];
                // $class = $control['rules'] > '' ? 'class="' . $class . '"' : '';
                //$required_label = (strpos($rules, 'required') !== FALSE) ? 'required' : '';
//                if (!in_array($control['control'], $this->ignore_controls))
//                    $html .= "<p class=\"$required_label\">{" . $name . ":label}<span class=\"field\">{" . $name . ":control}</span></p>";
//                else
//                    $ignore_controls .= "{" . $name . ":control}";

                if ($this->isRequeredField($Field->getName())) {
                    $required_class = 'required';
                } else {
                    $required_class = '';
                }

                $html .= sprintf(
                    $this->formRow, $required_class, $Field->getName(), $Field->getName()
                );
            }
        }

        if (!empty($controls))
            $html .= sprintf($this->formButton, $controls);

        if(!empty($this->formHtmlBootom)){
            $html .= $this->formHtmlBootom;
        }

        return $this->createForm($html);
    }

    protected function isRequeredField($name)
    {
        if (!isset($this->validation_rules[$name]))
            return false;

        if (is_array($this->validation_rules[$name])) {

            return in_array("required", $this->validation_rules[$name]);
        }

        return strpos($this->validation_rules[$name], "required") !== false;
    }

    public function setMessage_blank($message_blank)
    {
        $this->message_blank = $message_blank;
        return $this;
    }

    public function createMessage($text, $type = self::MESSAGE_ERROR)
    {
        return sprintf($this->message_blank, $type, $text);
    }

    public function addCustomMessage($message, $type = self::MESSAGE_INFO)
    {
        $this->custom_messages [] = [$message, $type];
        return $this;
    }

    public function createReturnLink()
    {
        if (!empty($this->backUrl)) {
            return sprintf(
                '<a href="%s">%s</a>', $this->backUrl, self::MESSAGE_BACK_URL
            );
        }
    }

    public function createNewLink()
    {
        if (!empty($this->newRecordUrl)) {
            return sprintf(
                '<a href="%s">%s</a>', $this->newRecordUrl, self::MESSAGE_ADD_URL
            );
        }
    }

    function setBackUrl($backUrl)
    {
        $this->backUrl = $backUrl;
        return $this;
    }

    function setNewRecordUrl($newRecordUrl)
    {
        $this->newRecordUrl = $newRecordUrl;
        return $this;
    }

    protected function getCustomMessages()
    {
        $tpl_html = '';
        if (count($this->custom_messages) > 0) {
            foreach ($this->custom_messages as $message) {
                $tpl_html .= $this->createMessage($message[0], $message[1]);
            }
        }
        return $tpl_html;
    }

    protected function getValidationMessages()
    {
        $tpl_html = '';
        if (count($this->validation_results) > 0) {
            foreach ($this->validation_results as $k => $result) {
                $tpl_html .= sprintf($this->createMessage("%s - %s"), $this->captions[$k], $result);
            }
        }
        return $tpl_html;
    }

    /**
     * Формируем форму, средствами CI
     *
     * @param mixed $tpl
     * @return
     */
    protected function createForm($tpl)
    {
        $tpl_html = '';

        $tpl_html .= $this->getValidationMessages();

        $tpl_html .= $this->getCustomMessages();

        $tpl_html .= form_open_multipart($this->action,
            array(
                'class' => $this->class,
                'id' => $this->name,
                'onsubmit' => $this->onsubmit
            ), $this->hidden_fields);
        $tpl_html .= '{% autoescape false %}' . $tpl . '{% endautoescape %}';
        $tpl_html .= form_hidden('submit_' . $this->name, 1);
        $tpl_html .= form_close();

        return $tpl_html;
    }

}