<?php

namespace Core\Form\Control;

/**
 * Description of TextEditor
 *
 * @author Dmitriy
 */
class TextEditor extends TextArea
{
    protected $compact = false;
    protected $height = 400;
    protected $mini = false;
    protected $width = "100%";
    protected $tinymce;

    function __construct(\Widgets\Jquery\Tinymce\Tinymce $tinymce, $name,
                         $rows = 3)
    {
        parent::__construct($name, $rows);
        $this->tinymce = $tinymce;
    }

    function getMini()
    {
        return $this->mini;
    }

    function setMini($mini)
    {
        $this->mini = $mini;
        return $this;
    }

    function getHeight()
    {
        return $this->height;
    }

    function setHeight($height)
    {
        $this->height = $height;
        return $this;
    }

    function getCompact()
    {
        return $this->compact;
    }

    function setCompact($compact)
    {
        $this->compact = $compact;
        return $this;
    }

    public function render(): string
    {
        return $this
            ->tinymce
            ->setCompact($this->compact)
            ->setMini($this->mini)
            ->setHeight($this->height)
            ->setWidth($this->width)
            ->setValue($this->value)
            ->Render();
    }


    /**
     * @param string $width
     * @return $this
     */
    public function setWidth(string $width)
    {
        $this->width = $width;
        return $this;
    }
}