<?

namespace Core\Form\Control;

/**
 * Description of Radio
 *
 * @author Admin
 */
class Radio extends FormField
{
    //put your code here
    protected $name;

    protected $options = [];

    protected $set;

    protected $class = "radio-inline";

    protected $template = '<div class="%s">
        <label><input type="radio" value="%s" name="%s" %s >%s</label>
    </div>';

    function __construct($name, array $options, $set = null)
    {
        $this->setName($name)->setOptions($options)->setSet($set);
    }


    public function render(): string
    {

        $html = "";

        foreach ($this->options as $option => $caption) {
            if (!$this->set) {
                $this->set = $option;
            }
            $html .= sprintf(
                $this->template,
                $this->class,
                $option,
                $this->name,
                $this->set == $option ? "checked" : "",
                $caption
            );
        }
        return $html;
    }

    function getName()
    {
        return $this->name;
    }

    function getOptions()
    {
        return $this->options;
    }

    function getSet()
    {
        return $this->set;
    }

    function getTemplate()
    {
        return $this->template;
    }

    function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    function setOptions($options)
    {
        $this->options = $options;
        return $this;
    }

    function setSet($set)
    {
        $this->set = $set;
        return $this;
    }

    function setTemplate($template)
    {
        $this->template = $template;
        return $this;
    }


}
