<?php

namespace Core\Form\Control;

/**
 * Description of FormControl
 *
 * @author Dmitriy
 */
abstract class FormControl extends BaseControl
{

    protected $name = self::class;
    protected $class;
    protected $id;
    protected $value;
    protected $style;
    protected $custom_value_fn = false;
    protected $data = [];

    function addData($name, $value)
    {
        $this->data [$name] = $value;
        return $this;
    }

    function getValue()
    {
        return $this->value;
    }

    function setValue($value)
    {
        $this->value = $value;
        return $this;
    }

    function getName()
    {
        return $this->name;
    }

    function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    function getClass()
    {
        return $this->class;
    }

    function setClass($class)
    {
        $this->class = $class;
        return $this;
    }

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getStyle()
    {
        return $this->style;
    }

    public function setStyle($style)
    {
        $this->style = $style;
        return $this;
    }

    public function getFn()
    {
        return $this->custom_value_fn;
    }

    public function setFn($fn, $method = false)
    {
        $this->custom_value_fn = !$method ? $fn : [$fn, $method];
        return $this;
    }


    abstract function render(): string;
}