<?php

namespace Core\Form\Control;

use Core\Template\Template;

/**
 * Description of DatePicker
 *
 * @author Dmitriy
 */
class DatePicker extends Input
{

    protected $template;
    protected $twig;

    function __construct($name, Template $template, \Twig_Environment $twig, $value = null, $width = false)
    {
        parent::__construct($name, $value, $width);
        $this->template = $template;
        $this->twig = $twig;
    }

    public function render(): string
    {
        $this->setClass('width100');
        $selector = $this->getName();
        $this->setId($selector);

        (new \Widgets\Jquery\DatePicker\DatePicker($this->template, $this->twig))
            ->setSelector("#" . $selector)
            ->render();

        return parent::render();
    }

}
