<?php

namespace Core\Form\Control;

use Core\Template\Template;
use Widgets\Jquery\ColorPicker\ColorPicker as CPicker;

/**
 * Description of ColorPicker
 *
 * @author Dmitriy
 */
class ColorPicker extends Input
{

    protected $template;
    protected $twig;

    function __construct($name, Template $template, \Twig_Environment $twig, $value = null, $width = false)
    {
        parent::__construct($name, $value, $width);
        $this->template = $template;
        $this->twig = $twig;
    }

    public function render(): string
    {
        $Colorpicker = new CPicker($this->getName(), $this->template, $this->twig);
        $Colorpicker->render();

        $this->setClass('width100');
        $this->setId('colorpicker_' . $this->getName());

        $html = parent::render();

        return $html . self::buildDemoColor($this->getName(), $this->getValue());
    }

    static function buildDemoColor($name, $color)
    {
        return '<span class="colorselector" id="colorSelector_' . $name .
            '"><span ' . ($color > '' ? 'style="background-color: ' . $color . '"' : '') .
            '></span></span>';
    }

}
