<?

namespace Core\Console\Commands;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use \Local\Factory\Logger as LoggerFactory;

/**
 * Адаптация картинок произврдителей
 *
 * @author Admin
 */
class Mailing extends Command
{

    protected $mailingService;
    protected $repo;
    protected $logger;
    
function __construct(
            \Diamond\Services\Mailing $mailingService, 
            \Diamond\Repositories\Mailing $repo
            )
    {
        parent::__construct();
        $this->mailingService = $mailingService;
        $this->repo = $repo;
        
    }

    protected function configure()
    {
        $this->setName('tools:mailing')->setDescription('Send mailing');
    }

    /**
     * 
     * @param InputInterface $input
     * @param OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {

        $mailing = $this->mailingService->getActiveMailing();
        
        $parts = 10;
        
        if(!count($mailing)){
             $output->writeln("send mailing - skip, not ready mails");
        }

        
        foreach($mailing as $mailinData){
            
            $id = $mailinData["mailing"]->getId();
            
            $this->logger = LoggerFactory::buildFileLogger(
                    \Monolog\Logger::INFO, 'mailingLogger', "mailing" . $id, "d_m_Y");
            
            $part = 0;
            
            if(!(array)$mailinData["data"]["emails"]){
                continue;
            }
            
            foreach((array)$mailinData["data"]["emails"] as $__key=>$__mail){
                
                $mailTo = $__mail["mail"];
                
                if(false!==\JBZoo\Utils\Email::isValid($mailTo)){
                    
                    try{
                        $this->mailingService->sendMailTo(
                            $mailTo,
                            $mailinData["data"]["subject"],
                            $mailinData["data"]["body"],
                            md5($mailTo)."_".md5($id)
                            );
                            
                       $this->logger->info(
                            sprintf(
                                    "Send mail to %s -  success",
                                    $mailTo
                                    )
                            );    
                             
                    }catch(\Diamond\Exceptions\EmailAccauntDisabledException $ex){
                        $this->logger->error(
                            sprintf(
                                    "Mail %s is unavailable: account is disabled",
                                    $ex->getEmail()
                                    )
                            );
                    }
    
                }
                else{
                     $this->logger->error(
                            sprintf(
                                    "Mail to %s -  error validate!",
                                    $mailTo
                                    )
                            );
                }

                
                unset($mailinData["data"]["emails"][$__key]);
                $part++;
                
                sleep(1);
                
                if($part >= $parts){
                    break;
                }
            }

            
            
            $file = $this->mailingService->getFilePath($id);

            
            file_put_contents($file, json_encode($mailinData["data"]));

            $prog = count($mailinData["data"]["emails"]);
            $count = $mailinData["data"]["count"];
            
            $progress =  ceil(($count-$prog)/$count * 100) * 1;
            
            $m = sprintf(
                            "Mailig № %s send success, part %s, %s completed!",
                            $id,
                            $part,
                            $progress . "%"
                            );
            
            $output->writeln(
                    $m
                    );
            
            $this->logger->info("Send mailing success!" . $m);
        }

       
    }

}