<?

namespace Core\Basket;

use Symfony\Component\HttpFoundation\Session\Session;

/**
 * Description of Basket
 *
 * @author Admin
 */
class Basket
{

    protected $session;

    function __construct(Session $session)
    {
        $this->session = $session;

        if (!$this->session->get("basket")) {
            $this->createStructure();
        }
    }

    /**
     *
     * @param type $name
     * @param type $price
     * @param type $amount
     * @param array $data доп. данные
     */
    public function addItem($article, $price, $amount, array $data)
    {
        // dump([$name, $price, $amount, $data]);
        $key = $this->createKey($article . serialize($data), $price);

        $this->updateItem($key, $article, $price, $amount, $data) ;

        return $key;
    }

    /**
     * @param string $key
     * @param $article
     * @param $price
     * @param $amount
     * @param array $data
     */
    public function updateItem(string $key, $article, $price, $amount, array $data): void
    {
        //ищем такую запись
        if (!$item = $this->getItemByKey($key)) {

            $item = [
                "article" => $article,
                "price" => $price,
                "amount" => $amount,
                "data" => $data
            ];

            $items[$key] = $item;

            $this->addItems($items);
        } else {
            $item["amount"] = $amount;
            $item["data"] = $data;
            $items[$key] = $item;
            $this->addItems($items);
        }

    }

    /**
     * Добавление позиций в корзину
     * @param array $items
     * @return boolean
     */
    private function addItems(array $items)
    {
        $basket = $this->session->get("basket");
        $basket["items"] = array_merge($basket["items"], $items);

        $this->session->set("basket", $basket);
        $this->recalcSumm();
        return true;
    }

    /**
     *
     * @return boolean
     */
    private function createStructure()
    {
        $this->session->set("basket",
            [
                "items" => [],
                "summ" => 0,
                "count" => 0
            ]);
        return true;
    }

    /**
     * Пересчет корзины, удаление левака
     * @return boolean
     */
    private function recalcSumm()
    {
        $basket = $this->session->get("basket");
        $summ = 0;
        $count = 0;

        foreach ($basket["items"] as $key => $item) {
            if ($item["amount"] > 0) {
                $price = (int)$item["amount"] * (float)$item["price"];
                $summ += $price;
                $count += (int)$item["amount"];
            } else {
                unset($basket["items"][$key]);
            }
        }
        $basket["summ"] = $summ;
        $basket["count"] = $count;
        $this->session->set("basket", $basket);
        return true;
    }

    /**
     *
     * @param  string $article
     * @param float $price
     * @param integer $amount
     * @return string
     */
    public function createKey($article, $price)
    {
        return md5($article . $price);
    }

    public function getSumm()
    {
        $basket = $this->session->get("basket");
        return (float)$basket["summ"];
    }

    /**
     * Получучения кол-ва
     * @return integer
     */
    public function getCount()
    {
        $basket = $this->session->get("basket");
        return (int)$basket["count"];
    }

    /**
     * Очистка всех
     * @return boolean
     */
    public function clear()
    {
        $this->createStructure();
        return true;
    }

    /**
     * Удаление по ключу
     * @param type $key
     * @return boolean
     */
    public function deleteByKey($key)
    {
        $basket = $this->session->get("basket");
        unset($basket["items"][$key]);
        $this->session->set("basket", $basket);
        $this->recalcSumm();
        return true;
    }

    /**
     * Получение содержимого
     * @return array
     */
    public function getItems()
    {
        $basket = $this->session->get("basket");
        return $basket["items"];
    }

    /**
     * Получение по ключу
     * @param integer $key
     * @return array|false
     */
    public function getItemByKey($key)
    {
        $items = $this->getItems();
        return isset($items[$key]) ? $items[$key] : false;
    }

}