<?php

namespace Core\Application;

use Twig\Cache\FilesystemCache;

class Loader
{

    private $settings = array();

    private static $_instance = null;

    private function __construct()
    {
        // приватный конструктор ограничивает реализацию getInstance ()
    }

    protected function __clone()
    {
        // ограничивает клонирование объекта
    }

    /**
     * Вызов модуля
     * @param type $name
     * @param array $params
     * @return string
     */
    public static function getModule($name, array $params = [])
    {
        $DI = self::getInstance()->load("DI");
        $debugbar = $DI->get(\DebugBar\StandardDebugBar::class);

        if(preg_match("~^(.*?)\.(.*?)$~",$name,$m)){
            $name = $m[1] .'\\Modules\\'. $m[2].'\\'.$m[2];
            $shortName = $m[1] . '\\'. $m[2];
        }
        elseif (preg_match("~^(.*)\\\Modules(\\\.*?)\\\.*$~is", $name, $m)) {
            $shortName = $m[1] . $m[2];
        } else {
            $shortName = $name;
        }

        $debugbar['messages']->debug(sprintf('App::getModule %s, with params %s', $shortName, json_encode($params)));

        $debugbar['time']->startMeasure($name, sprintf('Load module `%s`', $shortName));

        $module = $DI->get($name)->setParams($params);

        if (is_a($module, \Core\Contracts\ModuleCachableInterface::class)) {

            $key = $module->getCacheKey();
            $lifeTime = $module->getCacheLifeTime();

            if (empty($key) || empty($lifeTime)) {
                throw new Exception("cache key or lifetime not set for");
            }

            if (!$result = self::cacheFetch($key)) {
                $result = $module->process();
                self::cacheStore($key, $result, $lifeTime);
            }
        } else {
            $result = $module->process();
        }

        $module->afterProcess();

        $debugbar['time']->stopMeasure($name);
        return $result;
    }

    public static function cacheFetch($key)
    {
        $cache = new \Doctrine\Common\Cache\FilesystemCache(BASEPATH . '/app/cache/module');
        return $cache->fetch($key);
    }

    public static function cacheStore($key, $data, $lifetime)
    {
        $cache = new \Doctrine\Common\Cache\FilesystemCache(BASEPATH . '/app/cache/module');
        return $cache->save($key, $data,$lifetime);
    }

    public static function getInstance()
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function import($key, $value)
    {
        $this->settings[$key] = $value;
    }

    public function load($key)
    {
        return $this->settings[$key];
    }
}
