<?php

use Dotenv\Dotenv;
use League\Container\Container;
use League\Container\ReflectionContainer;

if(!BASEPATH){
    die("BASEPATH not set");
}

require_once BASEPATH . '/vendor/autoload.php';

/**
 * constants
 */
define("PACKPATH", BASEPATH . DIRECTORY_SEPARATOR . "packages" );


/**
 * Dotenv setup
 */
try {
    $dotenv = Dotenv::create(BASEPATH);
    $dotenv->load();
} catch (\Dotenv\Exception\InvalidPathException $ex) {
    die("environment variables are not defined, please create .env file");
}
catch (\Exception $ex){
    die($ex->getMessage());
}

if(!getenv("DB_PASS")){
    die("db password not set!");
}
if(!getenv("DB_USER")){
    die("db user not set!");
}
if(!getenv("BASE_URL")){
    die("BASE_URL not set environment");
}



//require_once FCPATH . '../bootstrap/container.php';

/**
 * Container setup
 */
$container = new Container();

$container->delegate(
	new ReflectionContainer() // Auto-wiring
);


/**
 * service providers
 */
$container->addServiceProvider(\Diamond\ServiceProvider::class);

require_once BASEPATH . '/bootstrap/container.php';




/**
 * add singliton
 */
\Core\Application\Loader::getInstance()->import("DI", $container);

require_once __DIR__ . '/config.php';
