<?php

use DebugBar\StandardDebugBar;
use Diamond\Services\Stat as statService;
use Dotenv\Dotenv;
use FastRoute\Dispatcher;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Whoops\Handler\CallbackHandler;
use Whoops\Handler\PrettyPageHandler;
use Whoops\Run;
use Whoops\Handler\PlainTextHandler;


include_once 'prepare.php';

/**
 * Error handler
 */
$request = Request::createFromGlobals();
$whoops = new Run;
$logger = $container->get(\Monolog\Logger::class);
/**
 * @var Diamond\Models\Stat\Stat $stat
 */
$statService = $container->get(statService::class);
$code = time();
$stat = $statService->createStat($request);
$debugBar = $container->get(StandardDebugBar::class);

/**
 *  env rules
 */
if (getenv('MODE') === 'dev') {
    error_reporting(-1);
    ini_set('display_errors', 1);
    if (getenv('LITE_DEBUG') == 1) {
        $whoops->pushHandler(new PlainTextHandler());
    } else {
        $whoops->pushHandler(new PrettyPageHandler);
    }

} else {
    ini_set('display_errors', 0);
    if (version_compare(PHP_VERSION, '5.3', '>=')) {
        error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT & ~E_USER_NOTICE & ~E_USER_DEPRECATED);
    } else {
        error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT & ~E_USER_NOTICE);
    }
}

$whoops->pushHandler(new Whoops\Handler\CallbackHandler(function (\Throwable $exception, $inspector, $run) use ($logger, $request, $statService, $stat, $code) {
    $code = "500-" . $code;
    $stat->setErrorMessage($code);
    $item = [
        "code" => $code,
        "uri" => $request->getUri(),
        "user" => sprintf("%s [%s]", $request->getClientIp(), $request->headers->get("user-agent")),
        "file" => $exception->getFile(),
        "line" => $exception->getLine(),
        "trace" => $exception->getTraceAsString()
    ];

    $logger->error($exception->getMessage(), $item);

    $content = "<body style='background-color: #f2f2f2'><h1>500 ERROR</h1><h2>Ошибка сервера</h2><p>На сервере произошла непредвиденная ошибка, код ошибки: %s. Администратору отправлено уведомление,
 она вскоре будет исправлена.</p><p>Попробуйте <a href='%s'>вернуться на главную страницу</a></p></body>";
    Response::create(sprintf($content,
        $code,
        getenv("BASE_URL")
    ), Response::HTTP_INTERNAL_SERVER_ERROR)->send();

    $statService->saveStat($stat);
}));

$whoops->register();


//Propel2 config
require_once __DIR__ . '/config.php';

/**
 * Routes
 */
$dispatcher = FastRoute\simpleDispatcher(function (FastRoute\RouteCollector $r) {
    $routes = require __DIR__ . '/routes.php';
    $local_routes = require BASEPATH . '/bootstrap/routes.php';

    foreach (array_merge($local_routes, $routes) as $route) {
        $r->addRoute($route[0], $route[1], $route[2]);
    }
});


/**
 * Dispatch
 */

$route_info = $dispatcher->dispatch($request->getMethod(), $request->getPathInfo());
switch ($route_info[0]) {
    case Dispatcher::NOT_FOUND:
        Response::create("404 Not Found", Response::HTTP_NOT_FOUND)->send();
        $stat->setErrorMessage("404-" . $code);
        break;
    case Dispatcher::METHOD_NOT_ALLOWED:
        Response::create("405 Method Not Allowed", Response::HTTP_METHOD_NOT_ALLOWED)->send();
        $stat->setErrorMessage("405-" . $code);
        break;
    case Dispatcher::FOUND:
        $class_name = $route_info[1][0];
        $method = $route_info[1][1];
        $vars = $route_info[2];


        try {

            $object = $container->get($class_name);

            $response = $object->$method($vars);

        } catch (Core\Exceptions\IsRedirectResponce $ex) {
            $response = $ex->getResponce();
        }


        if ($response instanceof Response) {
            if ($response->getStatusCode() === 404) {
                $stat->setErrorMessage("404-" . $code);
            }            
            $response->prepare($request);
            $response->send();
        }

        break;
}

$stat->setMemory($debugBar['memory']->getPeakUsage());
$stat->setElapsedTime($debugBar['time']->getRequestDuration());

$statService->saveStat($stat);