<?php

namespace Core\Registry;

use Core\Form\Control\BaseControl;
use Core\Form\FormBuilder;
use Core\Form\RepoForm;
use Core\Form\Simpleform;
use Core\Registry\Column;
use Core\Repository\PropelQueryAbstract;
use Core\Template\Template;
use Symfony\Component\HttpFoundation\Request;
use Twig_Environment;
use Widgets\Jquery\Jgrid\RepoJGrid;

/**
 * Description of RepoRegisry
 *
 * @author Dmitriy
 */
class RepoRegisry
{

    protected $repository;
    protected $template;
    protected $twig;
    protected $name;
    protected $request;
    protected $columns = [];
    protected $fields = [];
    protected $top_controls = [];
    protected $top_actions = [];

    /**
     * Просмотр записи в форме
     */
    const ACTION_FORM_UPDATE = "READ";

    /**
     * Просмотр записи в форме
     */
    const ACTION_FORM_ADD = "VIEW";

    /**
     * комманда на запись формы
     */
    const ACTION_FORM_SUBMIT = "SAVE";

    /**
     * Удаление записи
     */
    const ACTION_DELETE = "DELETE";
    const PRIMARY_KEY = "id";
    const SUBMIT_BUTTON_NAME = "submit";

    /**
     *
     * @var \Core\Form\RepoForm
     */
    protected $form;
    protected $grid;
    protected $captions = [];
    protected $multiselect = false;
    
    function __construct(PropelQueryAbstract $repository, FormBuilder $formBuilder, Template $template,
                         Twig_Environment $twig, Request $request, $name)
    {
        $this->repository = $repository;
        $this->template = $template;
        $this->twig = $twig;
        $this->name = $name;
        $this->request = $request;

        $this->form = $formBuilder->buildRepoValidationForm($this->repository, $this->name);
        $this->grid = new RepoJGrid($this->repository, $this->template, $this->twig);

        $this->form->setBackUrl($this->request->getPathInfo());
        $this->form->setNewRecordUrl(\adaptive_url(array('fn' => 'add'), ['id']));
    }
    
    /**
     * 
     * @param bool $multiselect
     * @return $this
     */
    function setMultiselect(bool $multiselect)
    {
        $this->grid->setMultiselect($multiselect);
        return $this;
    }

        
    function getForm()
    {
        return $this->form;
    }

    /**
     * 
     * @return RepoJGrid
     */
    function getGrid()
    {
        return $this->grid;
    }

    function setForm($form)
    {
        $this->form = $form;
        return $this;
    }

    function setGrid($grid)
    {
        $this->grid = $grid;
        return $this;
    }

    function getColumns()
    {
        return $this->columns;
    }

    function getFields()
    {
        return $this->fields;
    }

    public function addAction(BaseControl $control)
    {
        $this->top_actions [] = $control;
        return $this;
    }

    public function addControl(BaseControl $control)
    {
        $this->top_controls [] = $control;
        return $this;
    }
    
    /**
     * 
     * @param type $name
     * @return $this
     */
    public function removeControl($name){
        foreach($this->top_controls as $k => $control){
            if($control->getName() == $name){
                unset($this->top_controls[$k]);
                return $this;
            }
        }
        
         return $this;
    }
    
    /**
     * delete field
     * @param type $name
     * @return $this
     */
    public function removeField($name){
        foreach($this->fields as $k => $field){
            if($field->getControl()->getName() == $name){
                unset($this->fields[$k]);
                return $this;
            }
        }
        
         return $this;
    }
        
    
    /**
     * remove constrols
     * @param array $names
     * @return $this
     */
    public function removeControls(array $names)
    {
        foreach ($names as $name){
            $this->removeControl($name);
        }
        return $this;
    }

    public function setColumns(array $columns)
    {
        foreach ($columns as $column){
            $this->addColumn($column);
        }
        return $this;
    }

    public function setFields(array $fields)
    {
        $this->fields = $fields;
        return $this;
    }

    public function addColumn(Column $column)
    {

        $this->columns [] = $column;

        if ($column->getTitle()) {
            $this->captions[$column->getName()] = $column->getTitle();
        }

        return $this;
    }

    public function addField(Field $field)
    {
       
        if ( ! $field->getCaption() && isset($this->captions[$field->getControl()->getName()])) {
            $field->setCaption($this->captions[$field->getControl()->getName()]);
        }
         
        $this->fields [] = $field;
        return $this;
    }

    public function addHeader($txt)
    {
        $this->fields [] = new Field((new \Core\Form\Control\Header($txt))->setName(str_replace(" ", "_", $txt)));
        return $this;
    }

    public function render()
    {

        $grid = $this->grid;
        $form = $this->form;

        foreach ($this->columns as $Column) {

            /**
             * @var \Core\Registry\Column $Column
             */
            $grid->addColumn([
                'name'         => $Column->getName(),
                'key'          => $Column->getKey() === true,
                'hidden'       => $Column->getHidden() === true,
                'width'        => $Column->getWidth(),
                'title'        => $Column->getTitle(),
                "align"        => $Column->getAlign(), 
                'customformat' => $Column->getFn(),
                "search"       =>  $Column->getSearch()===false? false : true
            ]);
        }



        if (in_array($this->getAction(), [self::ACTION_FORM_UPDATE, self::ACTION_DELETE])) {
            if ( ! $Entity = $this->repository->findById($this->getPrimaryKey())) {
                $form->addCustomMessage(sprintf("Запись №%s не найдена, возможно была удалена. %s",
                                                $this->getPrimaryKey(), $form->createReturnLink()
                        ), Simpleform::MESSAGE_ERROR);
                return $form->render();
            }
        } else {
            $Entity = $this->repository->buildEntity();
        }
      
        $form->setEntity($Entity);

        if (self::ACTION_FORM_UPDATE == $this->getAction() || self::ACTION_FORM_ADD == $this->getAction()) {
            foreach ($this->fields as $Field) {
                $form = $this->buildForm($form, $Field);
            }

            return $form->render();
        } elseif (self::ACTION_DELETE == $this->getAction()) {

            try{
                
                $Entity->delete();
                
                if ($Entity->isDeleted() === true) {
                    $form->addCustomMessage("Запись успешно удалена! " . $form->createReturnLink(),
                                            Simpleform::MESSAGE_SUCCESS);
                } else {
                    $form->addCustomMessage("Ошибка при удалении записи", Simpleform::MESSAGE_ERROR);
                }

                
            } catch (\Propel\Runtime\Exception\PropelException $ex) {
                if(preg_match("~foreign key constraint fails.*?\(.*?\.\`(.*?)\`~", $ex->getPrevious()->getPrevious(),$m)){
                    $table = $m[1];
                }
                else{
                    $table = "";
                }
                
                
                $form->addCustomMessage("Ошибка при удалении, возможно есть связанная запись " . $table, Simpleform::MESSAGE_ERROR);
            }


            return $form->render();
        } else {
            return $grid->ajax_query() === false ? $this->getToolBarHtml() . $grid->render() : $grid->render();
        }
    }

    /**
     * Генерация элементов управления
     *
     * @return
     */
    protected function getToolBarHtml()
    {

        if (count($this->top_actions) == 0 && count($this->top_controls) == 0)
            return;

        $html = '<form id="form_action" method="POST"><div id="toolbar" class="tableoptions"><div class="action">';

        foreach ($this->top_actions as $Action) {
            $html .= $Action->render();
            $html .= ' &nbsp;';
        }


        $html .= '</div><div class="buttons">';

        foreach ($this->top_controls as $Control) {
            $html .= $Control->render();
            $html .= ' &nbsp;';
        }

        $html .= '</div></div></form>';


        return $html;
    }

    /**
     * 
     * @param RepoForm $form
     * @param Field $Field
     * @return RepoForm
     */
    protected function buildForm(RepoForm $form, Field $Field)
    {
        $form->addFieldControl(
                $Field->getControl(), $Field->getCaption(), $Field->getValidation(), $Field->getDescription()
        );
        return $form;
    }

    /**
     * 
     * @return type
     */
    protected function getPrimaryKey()
    {
        return $this->request->query->get(self::PRIMARY_KEY);
    }

    /**
     * 
     */
    protected function getAction()
    {

        switch (TRUE) {

            case $this->request->query->get("fn") == "add":

                return self::ACTION_FORM_ADD;

                break;
            case $this->request->query->get("fn") == "delete" && $this->getPrimaryKey() > 0:

                return self::ACTION_DELETE;

                break;
            case $this->getPrimaryKey() > 0:

                return self::ACTION_FORM_UPDATE;

                break;

            default:

                return false;

                break;
        }
    }
    
    /**
     * 
     * @param type $obj
     * @param type $name
     * @return $this
     */
    public function addValidationSuccessEvent($obj,$name = null)
    {
        $call = !is_array($obj)?[$obj,$name]:$obj;
        
        $this->form->addValidationSuccessEvent($call);
        
        return $this;
    }

    /**
     * 
     * @param type $param
     * @return $this
     */
    public function addValidationPrepareEvent($obj,$name = null)
    {
        $call = !is_array($obj)?[$obj,$name]:$obj;
        
        $this->form->addValidationPrepareEvent($call);
        
        return $this;
    }
    
}