<?php

namespace Core;

/**
 * Description of IniConfig
 *
 * @author Dmitriy
 */
abstract class IniConfig
{

    protected $data = [];
    protected $loaded = false;

    protected static $cacheData = [];

    protected function getPath()
    {
        return BASEPATH . '/app/settings/' . $this->getFileName();
    }

    function __construct()
    {
        $iniPath = $this->getPath();

        $data = $this->getDataFromFile($iniPath);

        foreach ($data as $k => $v) {

            if (property_exists($this, $k)) {

                $extractValue = base64_decode($v);

                if(strpos($extractValue,":{")!==false){
                    $this->{$k} = unserialize($extractValue);
                }
                else{
                    $this->{$k} = $extractValue;
                }


            }
        }
        
        
        //$this->loaded = true;
    }

    /**
     * @param string $file
     * @return array
     */
    private function getDataFromFile(string $file):array
    {
        if(isset(static::$cacheData[$file] )){
            return static::$cacheData[$file];
        }

        if (!file_exists($file)) {
            return [];
        }

        $data = parse_ini_file($file);

        static::$cacheData[$file] = $data;

        return $data;
    }

    /**
     * сохраняем в файл
     *
     * @param array $data
     * @return boolean
     */
    function save(array $data): bool
    {

        $tmp = '';

        foreach ($data as $key => $val) {
            if (!property_exists($this, $key))
                continue;

            if (!is_string($val)) {
                $val = serialize($val);
            }

            $val = base64_encode($val);

            $tmp .= "$key = \"" . addslashes($val) . "\"\n";
        }

        file_put_contents($this->getPath(), $tmp);

        return true;
    }

    abstract protected function getFileName();
}