<?php

namespace Core\Form;

use Core\Exceptions\BaseException;
use Core\Form\Control\FormControl;
use Core\IniConfig;
use Symfony\Component\HttpFoundation\Request;

/**
 * Для сохранения настроек
 *
 * @author Admin
 */
class SettingsForm extends Simpleform {

    protected $config;
    protected $ignored = [];

    public function __construct(IniConfig $config, $name, $action = '', Request $request = null) {
        parent::__construct($name, $action, $request);

        $this->config = $config;
        $this->setBackUrl($request->getPathInfo());
        $this->addValidationSuccessEvent([$this, 'submitForm']);
    }

    /**
     * 
     * @param type $data
     * @return type
     */
    public function submitForm($data) {

        if ($this->config->save($data)) {
            
            $this->addBuffer(
                    $this->createMessage("Настройки успешно сохранены. ". $this->createReturnLink(),self::MESSAGE_SUCCESS)
                    );
        } else {
            $this->addCustomMessage("Произошла ошибка при сохранении", self::MESSAGE_ERROR);
            $this->addBuffer($this->generateForm());
        }

        return true;
    }

    public function render() {
        
        if(count($this->ignored))
            throw new BaseException(
                    sprintf("attributes %s  not set in %s",
                    implode(", ",$this->ignored), get_class($this->config)
                            )
                    );


        return parent::render();
    }

    protected function setFieldValue(FormControl $control) {
        $name = $control->getName();

        if (!method_exists($this->config, "get" . $name)) {
            $this->ignored [] = $name;
        }

        $value = $this->request->request->get($name) ?: !method_exists($this->config, "get" . $name) ? $control->getValue() : $this->config->{"get" . $name}();

        return $control->setValue($value);
    }

    public function addField(Control\FormField $control, $caption = null, $validationrule = null, $desc = null) {

        $control = $this->setFieldValue($control);

        return parent::addField($control, $caption, $validationrule, $desc);
    }

}
