<?php

namespace Core\Form\Control;

/**
 * Description of Dropdown
 *
 * @author Dmitriy
 */
class Dropdown extends FormField
{

    protected $options = [];
    protected $onChange;

    function __construct($name, array $options)
    {
        $this->setName($name);
        $this->setOptions($options);
    }

    function getOptions()
    {
        return $this->options;
    }

    function setOptions(array $options)
    {
        $this->options = $options;
        return $this;
    }

    public function onChange($js)
    {
        $this->onChange = $js;
        return $this;
    }

    public function render()
    {
        $params = [
            'name'     => $this->getName(),
            'options'  => $this->getOptions(),
            'onChange' => $this->onChange
        ];

        if($this->getId()){
            $params["id"] = $this->getId();
        }
        
        if($this->getClass()){
            $params["class"] = $this->getClass();
        }
        if($this->getStyle()){
            $params["style"] = $this->getStyle();
        }
        if($this->getValue()!==null){
            $params["selected"] = $this->getValue();
        }
        foreach ($this->data as $k => $v) {
            $params["data-" . $k] = $v;
        }

        return \form_dropdown($params);
    }

}