<?

namespace Core\Console\Commands;

use Propel\Generator\Command\ModelBuildCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Input\InputDefinition;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\ConfirmationQuestion;

/**
 * Description of MigrationDiffCommand
 *
 * @author Admin
 */
class BuildModelCommand extends ModelBuildCommand {

    protected function configure() {
        $this->setName('db:build')
                ->setDescription('Build models by schema directory, db:build -d dir_name')
                ->setDefinition(
                        new InputDefinition(array(
                        new InputOption('dir', 'd', InputOption::VALUE_REQUIRED)
                        ))
                )
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output) {
        if (!$dir = $input->getOption('dir')) {
            $output->writeln("Config dir not set!");
            return;
        }

        $namespace = strtolower($dir);
        
        $path = array_change_key_case(include_once BASEPATH . '/vendor/composer/autoload_psr4.php',CASE_LOWER );
       
        if (!isset($path[$namespace . '\\']) || !count($path[$namespace . '\\'])) {
            throw new \Core\Exceptions\BaseException(sprintf("composer psr4 not set %s path", $namespace));
        }

        $pathToModels = $path[$namespace . '\\'][0];        
        
        $helper = $this->getHelper('question');
        $question = new ConfirmationQuestion(sprintf('This id correct Models path `%s/Models` (y/n)?', $pathToModels), false);
        
        if (!$helper->ask($input, $output, $question)) {
                $output->writeln("Cancel command!");
                return;
        }
        
        $this->getApplication()->add(new ModelBuildCommand());

        $command = $this->getApplication()->find('model:build');

        $returnCode = $command->run(new ArrayInput([
            'command'      => 'model:build',
            "--schema-dir" => "./app/db/" . $dir,
            "--output-dir" => $pathToModels
                ]), $output);
        
        $output->writeln("Build models success!");
    }

}
