<?php

namespace Core\Compress;

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
class Minify
{

    protected $jsmin;
    protected $cssmin;
    protected $publicPath;
    protected $publicCahchePath;

    public function __construct($publicPath, $publicCahchePath)
    {
        $this->publicPath = $publicPath;
        $this->publicCahchePath = $publicCahchePath;
    }

    /**
     * Проверка на существование кеша 
     * 
     * если есть возвращает имя файла
     * в противном false
     * 
     * @param type $param
     */
    public function is_cache_exist($files, $type = 'js', $debug = FALSE)
    {
        $files = trim($files, ",");
        $filesMd5 = md5($files);

        $files = explode(',', $files);

        $mTimeSum = 0;
        $publicPath = $this->publicPath;

        foreach ($files as $file) {

            if (file_exists($publicPath . $file . '.' . $type)) {
                $mt = filemtime($publicPath . $file . '.' . $type);
                $mTime[] = $mt;
                $mTimeSum += $mt;

                if ($debug)
                    echo "/* " . $file . '.' . $type . ' */' . "\r\n";
            }
            else {
                if ($debug)
                    echo '/* File not found: ' . $file . '.' . $type . ' */' . "\r\n";
            }
        }

        $path = $this->compressFilePath($filesMd5, $mTimeSum, $type, true);

        if ( ! file_exists($this->publicPath . $path))
            return null;

        return $path;
    }

    /**
     * Сжатие файлов
     * 
     * @param type $files
     * @param type $type
     */
    public function compress($files, $type = 'js')
    {

        if (ini_get('zlib.output_compression'))
            ob_start();
        elseif (function_exists('ob_gzhandler'))
            ob_start('ob_gzhandler');
        else
            ob_start();

        $files = trim($files, ",");
        $filesMd5 = md5($files);

        $files = explode(',', $files);

        $sendbody = true;

        if ( ! empty($files)) {

            //array_shift($files);
            if ( ! empty($files)) {
                $mTimeSum = 0;

                switch ($type) {
                    case 'js': header("Content-Type: application/x-javascript");
                        break;
                    case 'css': header("Content-Type: text/css");
                        break;
                    default: exit;
                }


                foreach ($files as $file) {

                    if (file_exists($this->publicPath . '/' . $file . '.' . $type)) {
                        $mt = filemtime($this->publicPath . '/' . $file . '.' . $type);
                        $mTime[] = $mt;
                        $mTimeSum += $mt;

                        echo "/* " . $file . '.' . $type . ' */' . "\r\n";
                    } else {
                        echo '/* File not found: ' . $file . '.' . $type . ' */' . "\r\n";
                    }
                }

                if ( ! file_exists($this->publicPath . $this->compressFilePath($filesMd5, $mTimeSum, $type)))
                    $this->compressFiles($files, $type, $filesMd5, $mTimeSum);

                $cache_file = $this->compressFilePath($filesMd5, $mTimeSum, $type);

                $output = file_get_contents($this->publicPath . $cache_file);

                /* -----------------------------------------

                  Output Compressed Data with Cache Headers

                  ----------------------------------------- */

                $lastmod = max($mTime);
                $expires = 60 * 60 * 24 * 3;
                $exp_gmt = gmdate("D, d M Y H:i:s", time() + $expires) . " GMT";
                $mod_gmt = gmdate("D, d M Y H:i:s", time() + (3600 * -5 * 24 * 365)) . " GMT";
                $expires = 60 * 60 * 24 * 10;
                $exp_gmt = gmdate("D, d M Y H:i:s", time() + $expires) . " GMT";
                $mod_gmt = gmdate("D, d M Y H:i:s", $lastmod) . " GMT";

                $etag = '"' . md5($output) . '"';


                /* Check 'If-Modified-Since' header
                  -------------------------------- */

                if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE']) && gmdate('D, d M Y H:i:s', $lastmod) . " GMT" == trim($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
                    header("HTTP/1.0 304 Not Modified");
                    header("Content-Length: 0");
                    $sendbody = false;
                }


                /* Check 'If-None-Match' header (ETag)
                  ----------------------------------- */

                if ($sendbody && isset($_SERVER['HTTP_IF_NONE_MATCH'])) {
                    $inm = explode(",", $_SERVER['HTTP_IF_NONE_MATCH']);
                    foreach ($inm as $i) {
                        if (trim($i) != $etag)
                            continue;
                        header("HTTP/1.0 304 Not Modified");
                        header("Content-Length: 0");
                        $sendbody = false;
                        break;
                    }
                }


                /* Caching headers (enable cache for one day)
                  ------------------------------------------ */

                $expires = 60 * 60 * 24 * 10;
                $exp_gmt = gmdate("D, d M Y H:i:s", time() + $expires) . " GMT";
                $mod_gmt = gmdate("D, d M Y H:i:s", $lastmod) . " GMT";
                header("Expires: {$exp_gmt}");
                header("Last-Modified: {$mod_gmt}");
                header("Cache-Control: public, max-age={$expires}");
                header("Pragma: !invalid");
                header("ETag: {$etag}");


                echo '/* Compressed (MD5 ' . $filesMd5 . '), Last Modified on ' . gmdate('D, d M Y H:i:s', $lastmod) . ' GMT */ ' . "\r\n" . $output;
            }
        }

        ob_end_flush();
    }

    /*
     * Path to Compressed File
     */

    private function compressFilePath($filesMd5, $totalTime, $type)
    {
        return $this->publicCahchePath . $filesMd5 . '-' . $totalTime . '.' . $type;
    }

    /*
     * Compress and Save Files
     */

    private function compressFiles($files, $type, $filesMd5, $totalTime)
    {
        $mTimeSum = 0;
        $output = '';

        if ($type == 'css')
            $CSSmin = new \Core\Compress\CSSmin();

        foreach ($files as $file) {
            $file = preg_replace('/[^a-zA-Z0-9\_\-\/\.]/', '', $file);

            //echo FCPATH . '/' . $file .'.' . $type."\n";

            if (file_exists($this->publicPath . '/' . $file . '.' . $type)) {

                $file_content = $this->getFileContent($this->publicPath . '/' . $file . '.' . $type, $type);


                $output .= "\r\n" . '/* File: ' . $file . '.' . $type . ' */' . "\r\n";


                if ($type == 'css') {

                    $output .= $CSSmin->run($file_content);
                } else
                    $output .= \Core\Compress\JSmin::minify($file_content);

                $mTimeSum += filemtime($this->publicPath . '/' . $file . '.' . $type);
            }
        }

        //exit($output);
        //РЅР° РІСЃСЏРєРёР№ СЃР»СѓС‡Р°Р№ СѓРґР°Р»РёРј РµСЃР»Рё РµСЃС‚СЊ СЃРѕРІРїР°РґРµРЅРёРµРј С„Р°Р№Р»РѕРІ
        if ( ! is_dir($this->publicPath . $this->publicCahchePath)) {
            mkdir($this->publicPath . $this->publicCahchePath, 777);
        }

        foreach (glob($this->publicPath . $this->publicCahchePath . $filesMd5 . '-*.' . $type) as $v)
            unlink($v);

        file_put_contents($this->publicPath . $this->compressFilePath($filesMd5, $totalTime, $type), $output);

        return true;
    }

    /**
     * 
     * @param type $path
     * @param type $type
     */
    private function getFileContent($path, $type): string
    {
        $file_content = file_get_contents($path) . "\n";

        //заменяем пути для изображений
        if ($type == 'css' && preg_match('~^(.*)\/[^\/]+$~Uis', $file, $m)) {
            $p = trim($m[1], '/');

            //((?:href|src|url))\(([\'\"]?)(.*?)([\'\"]?)\)
            $file_content = preg_replace("~((?:href|src|url))\(((?!(\'\/|\"\/|\/))(\"|\')?(.*?)(\"|\')?)\)~is",
                                         "$1('/{$p}/$5')", $file_content);
        }

//exit($file_content);exit;

        return $file_content;
    }

}