<?php

use DebugBar\StandardDebugBar;
use Diamond\Services\Stat as statService;
use Dotenv\Dotenv;
use FastRoute\Dispatcher;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Whoops\Handler\CallbackHandler;
use Whoops\Handler\PrettyPageHandler;
use Whoops\Run;
use Whoops\Handler\PlainTextHandler;

require_once BASEPATH . '/vendor/autoload.php';


include_once 'prepare.php';

/**
 * Error handler
 */
$request = Request::createFromGlobals();
$whoops = new Run;



if (getenv('MODE') === 'dev') {
    error_reporting(-1);
    ini_set('display_errors', 1);
    if(getenv('LITE_DEBUG')==1){
        $whoops->pushHandler(new PlainTextHandler());
    }
    else{
        $whoops->pushHandler(new PrettyPageHandler);
    }

} else {
    ini_set('display_errors', 0);
    if (version_compare(PHP_VERSION, '5.3', '>=')) {
        error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT & ~E_USER_NOTICE & ~E_USER_DEPRECATED);
    } else {
        error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT & ~E_USER_NOTICE);
    }

}

$whoops->pushHandler(new Whoops\Handler\CallbackHandler(function (\Throwable $exception, $inspector, $run) use ($container, $request) {
    $container->get(\Monolog\Logger::class)->error($exception->getMessage(), [
        "url"  => $request->getUri(),
        "file" => $exception->getFile(),
        "line" => $exception->getLine()
    ]);
    Response::create('Uh oh, something broke internally.', Response::HTTP_INTERNAL_SERVER_ERROR)->send();
}));

$whoops->register();



//Propel2 config
require_once __DIR__ . '/config.php';

/**
 * Routes
 */
$dispatcher = FastRoute\simpleDispatcher(function (FastRoute\RouteCollector $r) {
    $routes = require __DIR__ . '/routes.php';
    $local_routes = require BASEPATH . '/bootstrap/routes.php';

    foreach (array_merge($local_routes, $routes) as $route) {
        $r->addRoute($route[0], $route[1], $route[2]);
    }
});


/**
 * Dispatch
 */

$route_info = $dispatcher->dispatch($request->getMethod(), $request->getPathInfo());
switch ($route_info[0]) {
    case Dispatcher::NOT_FOUND:
        Response::create("404 Not Found", Response::HTTP_NOT_FOUND)->send();
        break;
    case Dispatcher::METHOD_NOT_ALLOWED:
        Response::create("405 Method Not Allowed", Response::HTTP_METHOD_NOT_ALLOWED)->send();
        break;
    case Dispatcher::FOUND:
        $class_name = $route_info[1][0];
        $method = $route_info[1][1];
        $vars = $route_info[2];
        $object = $container->get($class_name);


        try {

            $statService = $container->get(statService::class);

            /**
             * @var Diamond\Models\Stat\Stat $stat
             */
            $stat = $statService->createStat($request);

            $response = $object->$method($vars);

            $debugBar = $container->get(StandardDebugBar::class);
            $stat->setMemory($debugBar['memory']->getPeakUsage());
            $stat->setElapsedTime($debugBar['time']->getRequestDuration());

            $statService->saveStat($stat);

        } catch (Core\Exceptions\IsRedirectResponce $ex) {
            $response = $ex->getResponce();
        }

        if ($response instanceof Response) {
            $response->prepare(Request::createFromGlobals());
            $response->send();
        }
        break;

}
