<?php
namespace Core\Table;

use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\ActiveQuery\Criteria;

/**
 * Description of PropelDataTable
 *
 * @author Dmitriy
 */
class PropelDataTable extends SimpleTable{
    
    /**
     * 
     * @param type $Model
     * @param type $Column
     * @return type
     */
    protected function prepareRow($Model,$Column){
	
        $resultReal = method_exists($Model,'get' . $Column->getName()) ? $Model->{"get" . $Column->getName()}() : '&nbsp;';
        
        if(is_callable($Column->getFn()) || (is_array($Column->getFn()) and is_object($Column->getFn()[0])) ) {
            $result = call_user_func($Column->getFn(), $Model);
        }
        else{
            $result = $resultReal;
        }
	
        
        if (isset($this->summary[$Column->getName()]) && $resultReal > 0) {
            $this->summary[$Column->getName()] += (float)$resultReal;
        }          
	
	return $result;
    }
    
   /**
     * Получение записей
     * 
     * @return type
     */
    protected function getRows(){

	$this->setNavigation();

	$query = $this->repository->getQuery();

	if($this->beforSelectFn){
	    $query = call_user_func($this->beforSelectFn, $query);
	}

	if(count($this->multi_sort) > 0){
	    foreach($this->multi_sort as $sort => $order){
		$query->{'orderBy' . $sort}($order == 'asc' ? Criteria::DESC : Criteria::ASC );
	    }
	} else{

	    $query->{'orderBy' . $this->sort}($this->order == 'asc' ? Criteria::DESC : Criteria::ASC );
	}

	return $query->paginate($this->getPage(), $this->getLimit());
    }    
    
    protected function getCount(){
	$query = $this->repository->getQuery();

	if($this->beforSelectFn){
	    $query = call_user_func($this->beforSelectFn, $query);
	}
        
	return $query->count();
    }    
    
}
