<?php

namespace Core;

/**
 * Description of IniConfig
 *
 * @author Dmitriy
 */
abstract class IniConfig
{

    protected $data = [];
    protected $loaded = false;

    protected function getPath()
    {
        return BASEPATH . '/app/settings/' . $this->getFileName();
    }

    function __construct()
    {
        $ini_path = $this->getPath();

        if (file_exists($ini_path)) {
            $this->data = parse_ini_file($ini_path);
            foreach ($this->data as $k => $v) {

                if (property_exists($this, $k)) {

                    $extractValue = base64_decode($v);

                    $unser = @unserialize($extractValue);

                    if ($unser !== false) {
                        $this->{$k} = $unser;
                    } else {
                        $this->{$k} = $extractValue;
                    }
                }
            }
            $this->loaded = true;
        }
    }

    /**
     * сохраняем в файл
     * 
     * @param array $data
     * @return boolean
     */
    function save(array $data): bool
    {

        $tmp = '';

        foreach ($data as $key => $val) {
            if ( ! property_exists($this, $key))
                continue;

            if ( ! is_string($val)) {
                $val = serialize($val);
            }

            $val = base64_encode($val);

            $tmp .= "$key = \"" . addslashes($val) . "\"\n";
        }

        file_put_contents($this->getPath(), $tmp);

        return true;
    }

    abstract protected function getFileName();
}