<?php

use JBZoo\Utils\Url;
use Symfony\Component\HttpFoundation\Request;

/**
 * 
 * @param type $_url
 * @param type $_title
 * @param type $params
 * @param type $url_params
 * @return type
 */
function anchor($_url, $_title, $params = [], $url_params = [], $onlyUrl = FALSE)
{
    $mainUrl = Request::create($_url,"GET",$url_params)->getRequestUri();
    
    //$url = strpos($mainUrl, ":")!==false? $mainUrl : rtrim(getenv("BASE_URL"),'/').$mainUrl;
    
    $url = $mainUrl;
    
    extract($params);
    if($onlyUrl===true){
        return $url;
    }
    
    return sprintf('<a href="%s"%s%s%s%s>%s</a>', $url ,
                                                   isset($title) ? ' title="' . $title . '"' : '',
                                                   isset($class) ? ' class="' . $class . '"' : '',
                                                   isset($onclick) ? ' onclick="' . $onclick . '"' : '',
                                                   isset($target) ? ' target="' . $target . '"' : '',
                                                   $_title
    );
}

/**
 * Форматирует ссылку в SEO формате
 * @param type $uri
 * @param type $alias
 * @param type $title
 * @param type $attributes
 * @param type $params
 * @param type $onlyUrl
 * @return type
 */
function anchorSeo($uri = '', $alias = '', $title = '', $attributes = '', $params = array(), $onlyUrl = false)
{
    if ( ! empty($alias))
        return anchor($uri . '/' . $alias, $title, $attributes, $params,$onlyUrl);
    else
        return anchor($uri, $title, $attributes, $params, $onlyUrl);
}

function adaptive_url($params = [], $ignore = [])
{

    $params = array_merge(Request::createFromGlobals()->query->all(), $params);

    return Url::delArg($ignore, Url::addArg($params));
}

function input_get($name)
{
    return Request::createFromGlobals()->query->get($name);
}

function input_post($name)
{
    return Request::createFromGlobals()->request->get($name);
}

function current_url()
{
    return str_replace(Url::root(), '', Url::current());
}

function site_url(){
    return Url::root();
}

function nbs($n = 1)
{
    return str_repeat('&nbsp;', $n);
}
