<?php

namespace Core\Form\Control;

/**
 * Description of Textarea
 *
 * @author Dmitriy
 */
class TextArea extends FormField
{

    protected $rows;
    protected $cols;
    protected $required = false;

    function __construct($name, $rows = 3)
    {
        $this->setRows($rows);
        $this->setName($name);
    }

    function setRequired($required)
    {
        $this->required = $required;
        return $this;
    }

    function getRows()
    {
        return $this->rows;
    }

    function getCols()
    {
        return $this->cols;
    }

    function setRows($rows)
    {
        $this->rows = $rows;
        return $this;
    }

    function setCols($cols)
    {
        $this->cols = $cols;
        return $this;
    }

    public function render()
    {
        $data = [
            'name'  => $this->getName(),
            'class' => $this->getClass(),
            'style' => $this->getStyle(),
            'value' => $this->getValue(),
            'rows'  => $this->getRows(),
            'cols'  => $this->getCols()
        ];
        if ($this->required === true) {
            $data["required"] = "true";
        }

        return \form_textarea($data);
    }

}