<?php

namespace Core\Form\Control;

use Symfony\Component\HttpFoundation\Request;

/**
 * Description of ImgUpload
 *
 * @author d.lanec
 */
class ImgUpload extends FormField {

    protected $upload_dir;
    protected $max_width;
    protected $max_height;
    protected $request;
    protected $root_path;
    protected $translate = false;
    protected $previewImage = false;
    protected $previewImageSize = 50;
    
    /**
     * 
     * @param bool $previewImage
     * @return $this
     */
    function setPreviewImage(bool $previewImage)
    {
        $this->previewImage = $previewImage;
        return $this;
    }
    
    /**
     * 
     * @param bool $previewImage
     * @return $this
     */
    function setPreviewImageSize(int $previewImageSize)
    {
        $this->previewImageSize = $previewImageSize;
        return $this;
    }    
        
    function getTranslate() {
        return $this->translate;
    }

    function setTranslate($translate) {
        $this->translate = $translate;
        return $this;
    }

    function translit($translit) {

        $str = array(
            "ё" => "e", "й" => "i", "ц" => "c", "у" => "u", "к" => "c", "е" => "e",
            "н" => "n", "г" => "g", "ш" => "sh", "щ" => "sh", "з" => "z", "х" => "h", "ъ" => "", "ф" => "f",
            "ы" => "i", "в" => "v", "а" => "a", "п" => "p", "р" => "r", "о" => "o", "л" => "l", "д" => "d",
            "ж" => "j", "э" => "e", "я" => "ya", "ч" => "ch", "с" => "s", "м" => "m", "и" => "i", "т" => "t",
            "ь" => "", "б" => "b", "ю" => "u",
            "Ё" => "E", "Й" => "I", "Ц" => "C", "У" => "U", "К" => "C", "Е" => "E",
            "Н" => "N", "Г" => "G", "Ш" => "SH", "Щ" => "SH", "З" => "Z", "Х" => "H", "Ъ" => "", "Ф" => "F",
            "Ы" => "I", "В" => "V", "А" => "A", "П" => "P", "Р" => "R", "О" => "O", "Л" => "L", "Д" => "D",
            "Ж" => "J", "Э" => "E", "Я" => "YA", "Ч" => "CH", "С" => "S", "М" => "M", "И" => "I", "Т" => "T",
            "Ь" => "", "Б" => "B", "Ю" => "U"
        );

        $str = strtr($translit, $str);

        return $str;
    }

    /**
     * транслитериация с очисткой
     * @param type $txt
     */
    function translit_file($txt) {
        return preg_replace('/(\_{1})\1*/i', '$1', strtolower(preg_replace('~[^A-Za-z0-9\.]~', '_', $this->translit($txt))));
    }

    function getUploadDir() {
        return $this->upload_dir;
    }

    function getMaxWidth() {
        return $this->max_width;
    }

    function getMaxHeight() {
        return $this->max_height;
    }

    function setUploadDir($upload_path) {
        $this->upload_dir = $upload_path;
        return $this;
    }

    function setMaxWidth($max_width) {
        $this->max_width = $max_width;
        return $this;
    }

    function setMaxHeight($max_height) {
        $this->max_height = $max_height;
        return $this;
    }

    function __construct($name, $upload_dir, Request $request, $max_width = 1000, $max_height = 1000) {
        $this->setName($name);
        $this->setUploadDir($upload_dir);
        $this->setMaxHeight($max_height);
        $this->setMaxWidth($max_width);
        $this->request = $request;
        $this->root_path = $this->request->server->get("DOCUMENT_ROOT");
    }

    /**
     * 
     * @param type $img
     * @param type $public
     * @return type
     */
    protected function getImgPath($img = null, $public = false) {        
        if ($public === true)
            return $this->upload_dir . $img;
        else
            return $this->root_path . $this->upload_dir . $img;
    }

    /**
     * 
     * @return type
     */
    public function render() {

        return sprintf(
                '<span><input type="file" name="%s"/></span>' .
                '<span style="float:right">' .
                '<span>%s</span>' .
                ' %s %s удалить</span>', $this->getName(), 
                ($this->previewImage===true && $this->getValue()?sprintf(
                        '<img style="display:inline-block;position: absolute;z-index: 9999;height: %s;right: 100px;" title="%s" src="%s" style="max-height:%spx;max-width:%spx"/>',
                        "70%;",
                        $this->getValue(),
                        $this->getUploadDir().$this->getValue(),
                        $this->previewImageSize,
                        $this->previewImageSize,
                        $this->getValue()
                        ):$this->getValue()),
                //$this->getImgPath($this->getValue(),true),
                form_checkbox(array(
            'name' => $this->getName() . '_delete',
            'value' => 'Y'
                )), form_hidden($this->getName(), $this->getValue())
        );
    }

    function UploadImage() {
        
        $img = $this->request->files->get($this->name);
//dump(get_class_methods($img));
//dump($this->request->files);
//exit;
        if ($img && $img->getPathname()) {
            
            if(! is_dir($this->getImgPath())){
                mkdir($this->getImgPath(),0777,true);
            }
            $newname = $this->getTranslate() === true ? $this->translit_file($img->getClientOriginalName()) : $img->getClientOriginalName();

            if (copy($img->getPathname(), $this->getImgPath($newname))) {

                $this->request->request->set($this->name, $newname);

                return $newname;
            }
        }
    }

    public function deleteImage() {
        $delete = $this->request->request->get($this->name . '_delete');
        $image = $this->request->request->get($this->name);
        $root_path = $this->request->server->get("DOCUMENT_ROOT");

        if ($delete && unlink($this->getImgPath($image))) {
            $this->request->request->set($this->name, NULL);
            return true;
        }
        return false;
    }

}
