<?php

namespace Core\Form\Control;

/**
 * Description of Dropdown
 *
 * @author Dmitriy
 */
class DropdownMulti extends Dropdown
{

    public function render()
    {
        $params = [
            'name'     => $this->getName()."[]",
            'id'       => $this->getId(),
            'class'    => $this->getClass(),
            'style'    => $this->getStyle(),
            'selected' => $this->getValue(),
            'options'  => $this->getOptions(),
            'onChange' => $this->onChange,
            "multiple" => "true"
        ];

        foreach ($this->data as $k => $v) {
            $params["data-" . $k] = $v;
        }

        return \form_dropdown($params);
    }

}