<?

namespace Core\Form\Control;

/**
 * Description of Checkbox
 *
 * @author Admin
 */
class Checkbox extends Input{
    
    protected $checked = false;
    
    protected $type = "checkbox";
            
    function __construct($name,$value,$checked = false, $width = false) {
        parent::__construct($name, $value, $width);
        $this->checked = $checked;
    }
            
    function getChecked() {
        return $this->checked;
    }

    function setChecked($cheked) {
        $this->checked = $cheked;
    }
    
    public function render() {
        		return \form_checkbox(array_merge([
			'name'		 => $this->getName(),
			'id'		 => $this->getId(),
			'value'		 => $this->getValue(),
			'class'		 => $this->getClass(),	
			'type'		 => $this->getType(),
//			'maxlength'	 => '100',
//			'size'		 => '50',
			'style'		 => $this->getWidth(),
                        'onfocus'        => $this->onFocus,
                        'onBlur'         => $this->onBlur
		],$this->getAttributes()),$this->name,$this->checked);
    }

    
    
}
