<?php

namespace Core\Form\Control;

use Gregwar\Captcha\CaptchaBuilder;
use Symfony\Component\HttpFoundation\Session\Session;

/**
 * Description of Captcha
 *
 * @author Admin
 */
class Captcha extends FormField{
    
    protected $builder;
    
    protected $caption = "Код с картинки";
    
    protected $name_conteiner = "captcha_container";
            
    protected $width = "200px";
            
    protected $height = "50px";
    
    protected $session;
    
    protected $old_code;
    
    protected $template = '<div class="%s">
        <img src="%s" />
        <input type="text" name="%s" value="%s" onfocus="if (this.value == this.defaultValue) {
                    this.value = \'\';
                }" onblur="if (this.value == \'\') {
                            this.value = this.defaultValue
                        }" required="" >
    </div>';
            
    function __construct(Session $session) {
        $this->builder = new CaptchaBuilder;
        $this->session = $session;
        $this->old_code = $this->session->get("phrase");
        $this->session->set("phrase", $this->builder->getPhrase());   
    }
    
    function setTemplate($inputTemplate) {
        $this->template = $inputTemplate;
        return $this;
    }
    
    public function getOldCode(){
        return $this->old_code;
    }

    public function getBuilder() {
        return $this->builder;
    }
    
    function getWidth() {
        return $this->width;
    }

    function getHeight() {
        return $this->height;
    }

    function setWidth($width) {
        $this->width = $width;
        return $this;
    }

    function setHeight($height) {
        $this->height = $height;
        return $this;
    }

    
    function setCaption($caption) {
        $this->caption = $caption;
        return $this;
    }
    
    public function varifyCode($name){
        return $this->old_code == $name;
    }

    public function render() {
        $this->builder->build($this->width, $this->height);
             
        return sprintf($this->template,
                $this->name_conteiner,
                $this->builder->inline(),
                $this->name,
                $this->caption
                );
    }
    
}
