<?php

namespace Core\Console\Commands;

use Core\Exceptions\BaseException;
use Exception;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputDefinition;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use const BASEPATH;

/**
 * Description of HelloWorldCommand
 *
 * @author Dmitriy
 */
class BuildModuleCommand extends Command {

    protected function configure() {
        $this
                ->setName('build:module')
                ->setDefinition(
                        new InputDefinition(array(
                    new InputOption('module', 'm', InputOption::VALUE_REQUIRED)
                        ))
                )
                ->setDescription('Create module sceleton, build:module -m Shop.Slider');
    }

    /**
     * 
     * @param InputInterface $input
     * @param OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output) {

        try {
            $this->createModule($input,$output);
        } catch (BaseException $exc) {
            $output->writeln($exc->getMessage());            
        } catch (Exception $exc) {
            $output->writeln("error build module");
        }
    }

    /**
     * 
     * @param type $name
     * @return type
     */
    private function createModule(InputInterface $input, OutputInterface $output) {

        if (!$module = $input->getOption('module')) {
            throw new BaseException("module name not set");
        }

        if (!preg_match("~^(.*?)\.(.*?)$~", $module, $match)) {
            throw new BaseException("module name incorrect");
        }

        $namespace = $match[1];

        $class = $match[2];

        $path = include_once BASEPATH . '/vendor/composer/autoload_psr4.php';

        if (!isset($path[$namespace . '\\'][0])) {
            throw new BaseException(sprintf("composer psr4 not set %s path", $namespace));
        }

        $modPathDir = $path[$namespace . '\\'][0] . '/Modules/' . $class;

        $modPathClass = $modPathDir . '/' . $class . ".php";

        $modPathTpl = $modPathDir . '/tpl';

        $modPathTplFile = $modPathTpl . '/default.twig';

        $namespaceFull = sprintf("%s\Modules\%s", $namespace,$class);
        
        $codeClass = <<<EOF
<?

namespace $namespaceFull;

/**
* Description of {$class}
*
* @author Diamond Code Generator
*/
class {$class} extends \Core\ModuleController{

    
    public function process() {
        return \$this->render();
    }

}               
EOF;

        $codeTpl = "{# empty Twig template #}";

        //create dir module
        //create dir tpl module
        if (!is_dir($modPathDir)) {
            mkdir($modPathDir);
            $output->writeln("dir create success!");
        }

        if (!is_dir($modPathTpl)) {
            mkdir($modPathTpl);
            $output->writeln("template dir create success!");
        }

        if (!is_file($modPathClass)) {
            $fp = fopen($modPathClass, "w");
            // записываем в файл текст
            fwrite($fp, $codeClass);
            // закрываем
            fclose($fp);
            $output->writeln("file class create success!");
        }

        if (!is_file($modPathTplFile)) {
            $fp = fopen($modPathTplFile, "w");
            // записываем в файл текст
            fwrite($fp, $codeTpl);
            // закрываем
            fclose($fp);
            $output->writeln("file template create success!");
        }
    }

}
