<?php
namespace Core\Application;

class Loader{

    private $settings = array();

    private static $_instance = null;

    private function __construct(){
	// приватный конструктор ограничивает реализацию getInstance ()
    }

    protected function __clone(){
	// ограничивает клонирование объекта
    }

    /**
     * Вызов модуля
     * @param type $name
     * @param array $params
     * @return string
     */
    public static function getModule($name, array $params = []){
	$DI		 = self::getInstance()->load("DI");
	$debugbar	 = $DI->get(\DebugBar\StandardDebugBar::class);
        
        if(preg_match("~^(.*)\\\Modules(\\\.*?)\\\.*$~is", $name, $m)){
            $shortName = $m[1].$m[2];
        }
        else{
            $shortName = $name;
        }
        
	$debugbar['messages']->debug(sprintf('App::getModule %s, with params %s', $shortName, json_encode($params)));
        
        $debugbar['time']->startMeasure($name, sprintf('Load module `%s`' , $shortName));
	$module		 = $DI->get($name)->setParams($params);
        
        if(is_a($module, \Core\Contracts\ModuleCachableInterface::class)){

            $key = $module->getCacheKey();
            $lifeTime = $module->getCacheLifeTime();
          
            if(empty($key) || empty($lifeTime)){
                throw new Exception("cache key or lifetime not set for");
            }
            
            if(!$result = self::cacheFetch($key)){
                 $result = $module->process();  
                 self::cacheStore($key, $result , $lifeTime);
            }
        }
        else{
            $result = $module->process();    
        }
        
	$debugbar['time']->stopMeasure($name);
	return $result;
    }
    
    public static function cacheFetch($key)
    {

        $driver = \TFC\Cache\DoctrineCacheFactory::factory('memcache');
        $driver->setNamespace("modules");

        $result = $driver->fetch($key);
//dump($result);
        return $result;
    }    
    
    public static function cacheStore($key, $data, $lifetime)
    {
        $driver = \TFC\Cache\DoctrineCacheFactory::factory('memcache');
        $driver->setNamespace("modules");

        return $driver->save($key,$data,$lifetime);
    }

    public static function getInstance(){
	if(is_null(self::$_instance)){
	    self::$_instance = new self();
	}
	return self::$_instance;
    }

    public function import($key, $value){
	$this->settings[$key] = $value;
    }

    public function load($key){
	return $this->settings[$key];
    }
}
