<?php
use League\Container\Container;
use League\Container\ReflectionContainer;

if(!BASEPATH){
    die("BASEPATH not set");
}

/**
 * constants
 */
define("PACKPATH", BASEPATH . DIRECTORY_SEPARATOR . "packages" );

require_once BASEPATH . '/vendor/autoload.php';

/**
 * Dotenv setup
 */
try{
    $dotenv = new Dotenv\Dotenv(BASEPATH);
    $dotenv->load();
} catch (\Dotenv\Exception\InvalidPathException $ex) {
    die("environment variables are not defined, please create .env file");
}

if(!getenv("BASE_URL")){
    die("BASE_URL not set environment");
}

//Propel2 config
require_once __DIR__ . '/config.php';

//require_once FCPATH . '../bootstrap/container.php';

/**
 * Container setup
 */
$container = new Container();

$container->delegate(
	new ReflectionContainer() // Auto-wiring
);


/**
 * service providers
 */
$container->addServiceProvider(\Diamond\ServiceProvider::class);

require_once BASEPATH . '/bootstrap/container.php';




/**
 * add singliton
 */
\Core\Application\Loader::getInstance()->import("DI", $container);