<?php
namespace Core\Table;

use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\ActiveQuery\Criteria;

/**
 * Description of PropelDataTable
 *
 * @author Dmitriy
 */
class PropelDataTable extends SimpleTable{
    
    /**
     * 
     * @param type $Model
     * @param type $Column
     * @return type
     */
    protected function prepareRow($Model,$Column){
	if(is_callable($Column->getFn())) {
            $result = call_user_func($Column->getFn(), $Model);
        }
	else{
	    $result = method_exists($Model,'get' . $Column->getName()) ? $Model->{"get" . $Column->getName()}() : '&nbsp;';
	}
	
	return $result;
    }
    
   /**
     * Получение записей
     * 
     * @return type
     */
    protected function getRows(){

	$this->setNavigation();

	$query = $this->repository->getQuery();

//	if($this->beforSelectFn){
//	    $Repository = call_user_func($this->beforSelectFn, $Repository);
//	}

	if(count($this->multi_sort) > 0){
	    foreach($this->multi_sort as $sort => $order){
		$query->{'orderBy' . $sort}($order == 'asc' ? Criteria::DESC : Criteria::ASC );
	    }
	} else{

	    $query->{'orderBy' . $this->sort}($this->order == 'asc' ? Criteria::DESC : Criteria::ASC );
	}

	return $query->paginate($this->getPage(), $this->getLimit());
    }    
    
}
