<?php

namespace Core\Registry;

use Core\Form\Control\BaseControl;
use Core\Form\FormBuilder;
use Core\Form\RepoForm;
use Core\Form\Simpleform;
use Core\Registry\Column;
use Core\Repository\PropelQueryAbstract;
use Core\Template\Template;
use Symfony\Component\HttpFoundation\Request;
use Twig_Environment;
use Widgets\Jquery\Jgrid\RepoJGrid;

/**
 * Description of RepoRegisry
 *
 * @author Dmitriy
 */
class RepoRegisry
{
    protected $repository;
    protected $template;
    protected $twig;
    protected $name;
    protected $request;
    protected $columns      = [];
    protected $fields       = [];
    protected $top_controls = [];
    protected $top_actions  = [];

    /**
     * Просмотр записи в форме
     */
    const ACTION_FORM_UPDATE = "READ";

    /**
     * Просмотр записи в форме
     */
    const ACTION_FORM_ADD = "VIEW";

    /**
     * комманда на запись формы
     */
    const ACTION_FORM_SUBMIT = "SAVE";

    /**
     * Удаление записи
     */
    const ACTION_DELETE      = "DELETE";
    const PRIMARY_KEY        = "id";
    const SUBMIT_BUTTON_NAME = "submit";

    /**
     *
     * @var \Core\Form\RepoForm
     */
    protected $form;
    protected $grid;

    function __construct(PropelQueryAbstract $repository,
 FormBuilder $formBuilder,
                         Template $template, Twig_Environment $twig,
                         Request $request, $name)
    {
        $this->repository      = $repository;
        $this->template        = $template;
        $this->twig            = $twig;
        $this->name            = $name;
        $this->request         = $request;
        
        $this->form            = $formBuilder->buildRepoValidationForm($this->repository, $this->name);
        $this->grid            = new RepoJGrid($this->repository,
            $this->template, $this->twig);
        
        $this->form->setBackUrl($this->request->getPathInfo());
        $this->form->setNewRecordUrl(\adaptive_url(array('fn' => 'add'),['id']));
        
    }

    function getForm()
    {
        return $this->form;
    }

    /**
     * 
     * @return RepoJGrid
     */
    function getGrid()
    {
        return $this->grid;
    }

    function setForm($form)
    {
        $this->form = $form;
        return $this;
    }

    function setGrid($grid)
    {
        $this->grid = $grid;
        return $this;
    }

    function getColumns()
    {
        return $this->columns;
    }

    function getFields()
    {
        return $this->fields;
    }

    public function addControl(BaseControl $control)
    {
        $this->top_controls [] = $control;
        return $this;
    }

    public function setColumns(array $columns)
    {
        $this->columns = $columns;
        return $this;
    }

    public function setFields(array $fields)
    {
        $this->fields = $fields;
        return $this;
    }

    public function addColumn(Column $column)
    {
        $this->columns [] = $column;
        return $this;
    }

    public function addField(Field $field)
    {
        $this->cfields [] = $field;
        return $this;
    }

    public function render()
    {

        $grid = $this->grid;
        $form = $this->form;

        foreach ($this->columns as $Column) {

            $grid->addColumn([
                'name' => $Column->getName(),
                'key' => $Column->getKey() === true,
                'hidden' => $Column->getHidden() === true,
                'width' => $Column->getWidth(),
                'title' => $Column->getTitle(),
                'customformat' => $Column->getFn()
            ]);
        }



        if (in_array($this->getAction(),
                [self::ACTION_FORM_UPDATE, self::ACTION_DELETE])) {
            if(!$Entity = $this->repository->findById($this->getPrimaryKey())){
                $form->addCustomMessage(sprintf("Запись №%s не найдена, возможно была удалена. %s",
                        $this->getPrimaryKey(),
                        $form->createReturnLink()
                        ),
                    Simpleform::MESSAGE_ERROR);
                return $form->render();
            }
        } else {
            $Entity = $this->repository->buildEntity();
        }

        $form->setEntity($Entity);

        if (self::ACTION_FORM_UPDATE == $this->getAction() || self::ACTION_FORM_ADD
            == $this->getAction()) {
            foreach ($this->fields as $Field) {
                $form = $this->buildForm($form, $Field);
            }

            return $form->render();
        } elseif (self::ACTION_DELETE == $this->getAction()) {

            $Entity->delete();
            
            if ($Entity->isDeleted() === true) {
                $form->addCustomMessage("Запись успешно удалена! " . $form->createReturnLink(),
                    Simpleform::MESSAGE_SUCCESS);
            } else {
                $form->addCustomMessage("Ошибка при удалении записи",
                    Simpleform::MESSAGE_ERROR);
            }


            return $form->render();
        } else {
            return $grid->ajax_query() === false ? $this->getToolBarHtml().$grid->render()
                    : $grid->render();
        }
    }

    /**
     * Генерация элементов управления
     *
     * @return
     */
    protected function getToolBarHtml()
    {

        if (count($this->top_actions) == 0 && count($this->top_controls) == 0)
                return;

        $html = '<div id="toolbar" class="tableoptions"><div class="action">';

        foreach ($this->top_actions as $Action) {
            $html .= $Action->render();
            $html .= ' &nbsp;';
        }


        $html .= '</div><div class="buttons">';

        foreach ($this->top_controls as $Control) {
            $html .= $Control->render();
            $html .= ' &nbsp;';
        }

        $html .= '</div></div>';


        return $html;
    }

    /**
     * 
     * @param RepoForm $form
     * @param Field $Field
     * @return RepoForm
     */
    protected function buildForm(RepoForm $form, Field $Field)
    {
        $form->addFieldControl(
            $Field->getControl(), $Field->getCaption(), $Field->getValidation(),
            $Field->getDescription()
        );
        return $form;
    }

    /**
     * 
     * @return type
     */
    protected function getPrimaryKey()
    {
        return $this->request->query->get(self::PRIMARY_KEY);
    }

    /**
     * 
     */
    protected function getAction()
    {

        switch (TRUE) {

            case $this->request->query->get("fn") == "add":

                return self::ACTION_FORM_ADD;

                break;
            case $this->request->query->get("fn") == "delete" && $this->getPrimaryKey()
            > 0:

                return self::ACTION_DELETE;

                break;
            case $this->getPrimaryKey() > 0:

                return self::ACTION_FORM_UPDATE;

                break;

            default:

                return false;

                break;
        }
    }
}