<?php
use JBZoo\Utils\Url;
use Symfony\Component\HttpFoundation\Request;

function anchor($_url,$_title,$params = [],$url_params = []){
    extract($params);
    return sprintf('<a href="%s" %s %s %s>%s</a>',
	    Url::addArg( $url_params, $_url ),
	    isset($title) ? 'title="'.$title.'"' : '',
	     isset($class) ? 'class="'.$class.'"' : '',
	    isset($onclick) ? 'onclick="'.$onclick.'"' : '',
	    $_title
	    );
}

function adaptive_url($params = [], $ignore = []){
   
   $params = array_merge(Request::createFromGlobals()->query->all(),$params);
   
   return Url::delArg($ignore,Url::addArg($params));
}

function input_get($name){
   return Request::createFromGlobals()->query->get($name);
}

function input_post($name){
   return Request::createFromGlobals()->request->get($name);
}

function current_url(){
    return str_replace(Url::root(), '',Url::current());
}

function nbs($n = 1){
    return str_repeat('&nbsp;',$n);
}