<?php
namespace Core\Form;

use Core\Repository\PropelQueryAbstract;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Map\TableMap;
use Symfony\Component\HttpFoundation\Request;

/**
 * Description of RepoForm
 *
 * @author Dmitriy
 */
class RepoForm extends Simpleform implements \Psr\Log\LoggerAwareInterface{
    
    use \Psr\Log\LoggerAwareTrait;

    protected $repository;
    
    protected $entity;

    public function __construct(PropelQueryAbstract $repository,
				$name,
				$action = '', Request $request){
	
	parent::__construct($name, $action,$request);

	$this->repository = $repository;
	
	$this->addValidationSuccessEvent([$this,"validationSuccess"]);	
    }
    
    public function getEntity(){
	return $this->entity;
    }

    public function setEntity(ActiveRecordInterface  $entity){
	$this->entity = $entity;
	return $this;
    }
    
    public function addField(Control\FormField $control,
			     $caption = null,
			     $validationrule = null,
			     $desc = null){
	
	
	$row = $this->entity->toArray(TableMap::TYPE_FIELDNAME);
	
	if(isset($row[$control->getName()])){
	    $control->setValue($row[$control->getName()]);
	}	
	
	return parent::addField($control, $caption, $validationrule, $desc);
    }

    
    public function validationSuccess(array $data){
	
	try{
	    $this->entity->fromArray($data,TableMap::TYPE_FIELDNAME);

	    $this->repository->save($this->entity);
	    $back = $this->createReturnLink();
	    return $this->getCustomMessages() . $this->createMessage( 
                    "Запись успешно сохранена! " . $back . ($back > "" ? sprintf("%s или %s",nbs(),nbs()):"") . $this->createNewLink() 
                    , "msgsuccess");
	    
	} catch (\Exception $ex) {
	    
	    $this->logger->error($ex->getMessage());
	    
	    return $this->createMessage("Произошла ошибка при сохранении записи "  . $this->createReturnLink());
	}
	
    }
     
}
