<?php

namespace Core\Form;

use Core\Form\Control\Input;
use Core\Form\Control\TextArea;
use Core\Form\Control\TextEditor;
use Core\Form\Control\Uniform\Dropdown;
use Core\Form\Control\Uniform\InputTiny;
use Core\Template\Template;
use Core\TwigAwareInterface;
use Symfony\Component\HttpFoundation\Request;
use Twig_Environment;
use Widgets\Jquery\Tinymce\Tinymce;
use Symfony\Component\HttpFoundation\Session\Session;
use Core\Form\Control\Captcha;

/**
 * Description of TextEditorBuilder
 *
 * @author Dmitriy
 */
class ControlBuilder implements TwigAwareInterface {

    use \Core\TwigAwareTrait;
    
    protected $twig;
    protected $template;
    protected $request;
    protected $session;

    function __construct(Template $template, Request $request, Session $session) {
        $this->template = $template;
        $this->request = $request;
        $this->session = $session;
    }

    public function buildTextArea($name,$rows = 3) {
        return new TextArea($name,$rows);
    }

    public function buildInput($name) {
        return new Input($name);
    }
    
    public function buildInputSmall($name) {
        return (new Input($name))->setClass("smallinput");
    }  
    
    public function buildInputLittle($name) {
        return (new Input($name))->setClass("width100");
    }  
    
    public function buildSubmitButton($name,$value) {
        return  new Control\Submit($name,$value);
    }
   
    
    public function buildInputTiny($name) {
        return new InputTiny($name);
    }

    public function buildDropdownUniform($name, array $options) {
        return new Dropdown($name, $options);
    }
    
    public function buildAutoDropdown($name,array $options) {
        
        $selector = 'a-select-'.$name;
        $auto = new \Widgets\Jquery\Autocomplit\Autocomplit($selector,$this->template, $this->twig);
        $auto->Render();
        return (new Dropdown($name, $options))->setClass('chzn-select')->setId($selector);
    }
    
    public function buildTextEditor($name) {
        $editor = new Tinymce($this->template, $this->twig, $name);
        return (new TextEditor($editor, $name))->setClass('tiny_' . $name);
    }    
    
    public function buildDropdownYNUniform($name){
        return new Dropdown($name, [
            "N" =>  "Нет",
            "Y" =>  "Да"
        ]);
    }

    public function buildImgUpload($name, $path, $translate = false) {
        return (new Control\ImgUpload($name, $path, $this->request))->setTranslate($translate);
    }

    /**
     * 
     * @param type $width
     * @param type $height
     * @return \Core\Form\Control\Captcha
     */
    public function buildCaptcha($width = 150, $height = 40) {
        return (new Captcha($this->session))->setWidth($width)->setHeight($height);
    }
    
    public function buildColorPicker($name) {
        return new Control\ColorPicker($name,$this->template, $this->twig);	
    }
    
    public function buildDatePicker($name) {
        return new Control\DatePicker($name,$this->template, $this->twig);
    }

}
