<?php

namespace Core\Form\Control;

/**
 * Description of Textarea
 *
 * @author Dmitriy
 */
class TextArea extends FormField
{
	protected $rows;
	
	protected $cols;
			
	function __construct($name,$rows = 3)
	{
		$this->setRows($rows);
		$this->setName($name);
	}

	function getRows()
	{
		return $this->rows;
	}

	function getCols()
	{
		return $this->cols;
	}

	function setRows($rows)
	{
		$this->rows = $rows;
                return $this;
	}

	function setCols($cols)
	{
		$this->cols = $cols;
                return $this;
	}

	
	public function render()
	{
		return \form_textarea([
			'name'	=>	$this->getName(),
			'class'	=>	$this->getClass(),
			'style'	=>	$this->getStyle(),
			'value'	=>	$this->getValue(),
			'rows'	=>	$this->getRows(),
			'cols'	=>	$this->getCols()
		]);
	}
}
