<?php

namespace Core\Form\Control;

/**
 * Description of Dropdown
 *
 * @author Dmitriy
 */
class Dropdown extends FormField
{
	protected $options = [];
	
	protected  $onChange;

	function __construct($name, array $options)
	{
		$this->setName($name);
		$this->setOptions($options);
	}
			
	function getOptions()
	{
		return $this->options;
	}

	function setOptions(array $options)
	{
		$this->options = $options;
		return $this;
	}
	
	public function onChange($js)
	{
		$this->onChange = $js;
		return $this;
	}

	public function render()
	{
		return \form_dropdown([
			'name'	=>	$this->getName(),
			'id'	=>	$this->getId(),
			'class'	=>	$this->getClass(),
			'style'	=>	$this->getStyle(),
			'selected'	=>	$this->getValue(),
			'options'	=>	$this->getOptions(),
			'onChange'	=>	$this->onChange
		]);
	}
}
