<?php
namespace Core\Console\Commands;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Description of HelloWorldCommand
 *
 * @author Dmitriy
 */
class InstallPackagesCommand extends Command{

    protected function configure(){
	$this->setName('prepare:packages')
		->setDescription('Copy packages migration and assets');
    }

    protected function execute(InputInterface $input, OutputInterface $output){
	$finder = \Symfony\Component\Finder\Finder::create();

	try{
	    
	    $iterator = $finder->files()->in(BASEPATH . "/vendor/*/*/db/migrations");

	    $this->copyFiles($iterator, $output);
	    
	} catch(\Exception $exc){
	    $output->writeln("nothing to install from vendor");
	}
	
	try{
	    
	    $iterator = $finder->files()->in(PACKPATH . "/*/db/migrations");

	    $this->copyFiles($iterator, $output);
	    
	} catch(\Exception $exc){
	    $output->writeln("nothing to install from packages");
	}	

    }
    
    protected function copyFiles($iterator,OutputInterface $output){
	foreach($iterator as $file){

		if(!copy($file->getRealpath(), BASEPATH . '/app/db/migrations/' . $file->getRelativePathname())){
		    $output->writeln(sprintf("error copy migration %s...", $file->getRelativePathname()));
		} else{
		    $output->writeln(sprintf("copy migration %s", $file->getRelativePathname()));
		}
	}	
    }
}
