<?php
namespace Core;

use Twig_Environment;
use DebugBar\StandardDebugBar;
use Symfony\Component\HttpFoundation\Response;

/**
 * Description of BaseController
 *
 * @author d.lanec
 */
abstract class BaseController implements 
				\Psr\Log\LoggerAwareInterface, 
				PageInterface, 
				TwigAwareInterface
	{

    /**
     * @var Twig_Environment
     */
    protected $twig;

    /**
     *
     * @var StandardDebugBar
     */
    protected $debugbar;

    use \Psr\Log\LoggerAwareTrait;

    public function setTwig(Twig_Environment $twig){
	$this->twig = $twig;
	return $this;
    }

    public function setDebugbar(StandardDebugBar $debugbar){
	$this->debugbar = $debugbar;
	return $this;
    }
}
